<?php

/**
 * AllinoneAccessibility Connector
 *
 * @package allinoneaccessibility
 */

require_once dirname(__FILE__, 4) . '/config.core.php';
require_once MODX_CORE_PATH . 'config/' . MODX_CONFIG_KEY . '.inc.php';
require_once MODX_CONNECTORS_PATH . 'index.php';

$corePath = $modx->getOption(
    'allinoneaccessibility.core_path',
    null,
    $modx->getOption('core_path') . 'components/allinoneaccessibility/'
);
require_once $corePath . 'model/allinoneaccessibility/allinoneaccessibility.class.php';
$modx->allinoneaccessibility = $modx->getService(
    'allinoneaccessibility',
    'AllinoneAccessibility',
    $corePath . 'model/allinoneaccessibility/',
    [
        'core_path' => $corePath
    ]
);

$modx->lexicon->load('allinoneaccessibility:default');

/* handle request */
$path = $modx->getOption('processorsPath', $modx->allinoneaccessibility->config, $corePath . 'processors/');
$modx->request->handleRequest(
    [
    'processors_path' => $path,
    'location' => '',
    ]
);
