<?php

class AllinoneAccessibilityHomeManagerController extends modExtraManagerController
{
    /**
     *
     *
     * @var AllinoneAccessibility $allinoneaccessibility
     */
    public $allinoneaccessibility;

    public function initialize()
    {

        $server_url = $this->modx->getOption('site_url');
        $websitename = parse_url($server_url, PHP_URL_HOST);

        $packageType = "free-widget";
            
        // Array of details to send
        $arrDetails = array(
            'company_name' => '',
            'website' => base64_encode($websitename),
            'package_type' => $packageType,
            'start_date' => date(DATE_ISO8601),
            'end_date' => '',
            'price' => '',
            'discount_price' => '0',
            'platform' => 'Craft',
            'api_key' => '',
            'is_trial_period' => '',
            'is_free_widget' => '1',
            'bill_address' => '',
            'country' => '',
            'state' => '',
            'city' => '',
            'post_code' => '',
            'transaction_id' => '',
            'subscr_id' => '',
            'payment_source' => ''
        );
        
        // First API URL to fetch autologin link
        $apiUrl = "https://ada.skynettechnologies.us/api/get-autologin-link";
        
        // Set up cURL for the first API request
        $ch = curl_init($apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['website' => base64_encode($websitename)]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        
        // Execute the request and get the response
        $response = curl_exec($ch);
        if(curl_errno($ch)) {
          
        }
        curl_close($ch);
        
        // Decode the response to check if the link is present
        $result = json_decode($response, true);
        if (isset($result['link'])) {
            // Successfully got the link
        
            
        } else {
            // Link not found, proceed with second API call
          
        
            // Second API URL to add user domain
            $secondApiUrl = "https://ada.skynettechnologies.us/api/add-user-domain";
        
            // Set up cURL for the second API request
            $ch = curl_init($secondApiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($arrDetails));
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json'
            ));
        
            // Execute the second request and get the response
            $response = curl_exec($ch);
            if(curl_errno($ch)) {
             
               
            }
            curl_close($ch);
        
            // Decode the second response to handle the result
            $data = json_decode($response, true);
            
           
         }


        if (empty($this->modx->version)) {
            $this->modx->getVersionData();
        }
        /* Check modx version */
        if ($this->modx->version['version'] < 3) {
            $corePath = $this->modx->getOption(
                'allinoneaccessibility.core_path',
                null,
                $this->modx->getOption('core_path', null, MODX_CORE_PATH) . 'components/allinoneaccessibility/'
            );
            $this->allinoneaccessibility = $this->modx->getService(
                'allinoneaccessibility',
                'AllinoneAccessibility',
                $corePath . 'model/allinoneaccessibility/',
                [
                    'core_path' => $corePath
                ]
            );
        } else {
            $this->allinoneaccessibility = $this->modx->getService('allinoneaccessibility');
        }
        $this->allinoneaccessibility->config['modx3'] = ($this->modx->version['version'] >= 3);
        /* add allinoneaccessibility.js - which is use for render the iframe */
        $this->addJavascript($this->allinoneaccessibility->config['jsUrl'] . 'mgr/allinoneaccessibility.js');
        
        /* Create iFrame url with uniq hash value for every user */
        $base_url = $this->modx->getOption('site_url');
        $siteUrl = preg_replace("/www\.|https?:\/\/|\/$|\/?\?.+|\/.+|^\./", '', $base_url);
        $hash = sha1($this->modx->getOption('base_url')."modx_accessibility_" . $siteUrl);
        $domain = parse_url($base_url, PHP_URL_HOST);
        $iframeUrl = "https://skynettechnologies.com/add-ons/reports/setup/modx?hash=$hash&url=".$domain;
           // $iframeUrl = "https://skynettechnologies.com/add-ons/reports/setup/modx?hash=$hash&url=".$domain;
           
        /* for cache clear */
        $this->modx->cacheManager->refresh();
            
        $this->addHtml(
            '<script type="text/javascript">
            var iframe = "'.$iframeUrl.'";
        Ext.onReady(function() {
            allinone.config = ' . json_encode($this->allinoneaccessibility->config) . ';
        });
        </script>'
        );
        parent::initialize();
    }

    public function getLanguageTopics()
    {
        return ['allinoneaccessibility:default'];
    }

    public function checkPermissions()
    {
        return true;
    }

    public function getPageTitle()
    {
        return $this->modx->lexicon('allinoneaccessibility');
    }

    public function loadCustomCssJs()
    {
        $this->addCss($this->allinoneaccessibility->config['cssUrl'] . 'mgr/main.css');
        $this->addLastJavascript($this->allinoneaccessibility->config['jsUrl'] . 'mgr/widgets/home.panel.js');
        $this->addLastJavascript($this->allinoneaccessibility->config['jsUrl'] . 'mgr/sections/index.js');
        $this->addLastJavascript(MODX_MANAGER_URL . 'assets/modext/util/datetime.js');
    }

    public function getTemplateFile()
    {
        return $this->allinoneaccessibility->config['templatesPath'] . 'home.tpl';
    }
}
