/*!
 * dbAdmin - Database Tables Administration for MODX
 * Version: 1.3.1
 * Build date: 2023-04-18
 */
var dbadmin=function(e){dbadmin.superclass.constructor.call(this,e=e||{})},dbAdmin=(Ext.extend(dbadmin,Ext.Component,{page:{},window:{},grid:{},tree:{},panel:{},combo:{},config:{},view:{},utils:{}}),Ext.reg("dbadmin",dbadmin),new dbadmin);dbAdmin.utils.renderBoolean=function(e){return e?String.format('<span class="green">{0}</span>',_("yes")):String.format('<span class="red">{0}</span>',_("no"))},dbAdmin.utils.getMenu=function(e,t,i){var a,n,d,s,r,o=[];for(r in e)if(e.hasOwnProperty(r)){var l=e[r];if(l.menu){if(0<o.length&&/^remove/i.test(l.action)&&o.push("-"),1<i.length){if(!l.multiple)continue;"string"==typeof l.multiple&&(l.title=l.multiple)}a=l.cls||"",n=l.icon||"",d=l.title||l.title,s=l.action?t[l.action]:"",o.push({handler:s,text:String.format('<span class="{0}"><i class="x-menu-item-icon {1}"></i>{2}</span>',a,n,d)})}else"-"===l&&o.push("-")}return o},dbAdmin.utils.renderActions=function(e,t,i){var a,n,d,s,r,o=[];for(s in i.data.actions)i.data.actions.hasOwnProperty(s)&&(r=i.data.actions[s]).button&&(d=r.cls||"",a=r.icon||"",n=r.action||"",r=r.title||"",d=String.format('<li class="{0}"><span class="btn btn-default {1}" data-action="{2}" title="{3}"></span></li>',d,a,n,r),o.push(d));return String.format('<ul class="dbadmin-row-actions">{0}</ul>',o.join(""))},dbAdmin.combo.Types=function(e){e=e||{},Ext.applyIf(e,{hiddenName:"outputType",emptyText:_("dbadmin.output_type"),triggerAction:"all",mode:"local",hideMode:"offsets",autoScroll:!0,maxHeight:200,store:[["var_export","var_export"],["print_r","print_r"]],editable:!1}),dbAdmin.combo.Types.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.combo.Types,MODx.combo.ComboBox),Ext.reg("dbadmin-output-types",dbAdmin.combo.Types),dbAdmin.panel.Home=function(e){e=e||{},Ext.apply(e,{cls:"container home-panel"+(dbAdmin.config.debug?" debug":"")+" modx"+dbAdmin.config.modxversion,defaults:{collapsible:!1,autoHeight:!0},items:[{html:"<h2>"+_("dbadmin")+"</h2>"+(dbAdmin.config.debug?'<div class="ribbon top-right"><span>'+_("dbadmin.debug_mode")+"</span></div>":""),border:!1,cls:"modx-page-header"},{defaults:{autoHeight:!0},border:!0,cls:"dbadmin-panel",items:[{xtype:"dbadmin-panel-overview"}]},{cls:"treehillstudio_about",html:'<img width="146" height="40" src="'+dbAdmin.config.assetsUrl+'img/mgr/treehill-studio-small.png" srcset="'+dbAdmin.config.assetsUrl+'img/mgr/treehill-studio-small@2x.png 2x" alt="Treehill Studio">',listeners:{afterrender:function(){this.getEl().select("img").on("click",function(){var e='<span style="display: inline-block; text-align: center">&copy; 2018-2022 by Sergey Shlokov <a href="https://github.com/sergant210" target="_blank">github.com/sergant210</a><br><img src="'+dbAdmin.config.assetsUrl+'img/mgr/treehill-studio.png" srcset="'+dbAdmin.config.assetsUrl+'img/mgr/treehill-studio@2x.png 2x" alt="Treehill Studio" style="margin-top: 10px"><br>&copy; 2023 by <a href="https://treehillstudio.com" target="_blank">treehillstudio.com</a></span>';Ext.Msg.show({title:_("dbadmin")+" "+dbAdmin.config.version,msg:e,buttons:Ext.Msg.OK,cls:"treehillstudio_window",width:358})})}}}]}),dbAdmin.panel.Home.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.panel.Home,MODx.Panel),Ext.reg("dbadmin-panel-home",dbAdmin.panel.Home),dbAdmin.panel.HomeTab=function(e){e=e||{},Ext.applyIf(e,{id:"dbadmin-panel-"+e.tabtype,title:e.title,items:[{html:"<p>"+e.description+"</p>",border:!1,cls:"panel-desc"},{layout:"form",cls:"x-form-label-left main-wrapper",defaults:{autoHeight:!0},border:!0,items:[{id:"dbadmin-panel-"+e.tabtype+"-grid",xtype:"dbadmin-grid-"+e.tabtype,preventRender:!0}]}]}),dbAdmin.panel.HomeTab.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.panel.HomeTab,MODx.Panel),Ext.reg("dbadmin-panel-hometab",dbAdmin.panel.HomeTab),dbAdmin.panel.Overview=function(e){e=e||{},this.ident="dbadmin-overview-"+Ext.id(),this.panelOverviewTabs=[{xtype:"dbadmin-panel-hometab",title:_("dbadmin.tables"),description:_("dbadmin.tables_desc"),tabtype:"tables"},{xtype:"dbadmin-panel-sql"}],Ext.applyIf(e,{items:[{id:"dbadmin-tabpanel",xtype:"modx-tabs",border:!0,stateful:!0,stateId:"dbadmin-panel-overview",stateEvents:["tabchange"],getState:function(){return{activeTab:this.items.indexOf(this.getActiveTab())}},autoScroll:!0,deferredRender:!0,forceLayout:!1,defaults:{layout:"form",autoHeight:!0,hideMode:"offsets"},items:this.panelOverviewTabs,listeners:{tabchange:function(e,t){"dbadmin-panel-hometab"===t.xtype&&Ext.getCmp("dbadmin-panel-"+t.tabtype+"-grid")&&Ext.getCmp("dbadmin-panel-"+t.tabtype+"-grid").getStore().reload()}}}]}),dbAdmin.panel.Overview.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.panel.Overview,MODx.Panel),Ext.reg("dbadmin-panel-overview",dbAdmin.panel.Overview),dbAdmin.window.UpdateTable=function(e){(e=e||{}).id||(e.id="dbadmin-table-window-update"),Ext.applyIf(e,{title:_("dbadmin.table_properties"),width:400,autoHeight:!0,url:dbAdmin.config.connectorUrl,action:"mgr/tables/update",resizable:!1,maximizable:!1,fields:this.getFields(e),keys:[{key:Ext.EventObject.ENTER,shift:!0,fn:function(){this.submit()},scope:this}]}),dbAdmin.window.UpdateTable.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.window.UpdateTable,MODx.Window,{getFields:function(e){return[{xtype:"textfield",fieldLabel:_("dbadmin.table"),name:"name",id:e.id+"dbadmin-table-name",anchor:"100%",allowBlank:!1},{xtype:"hidden",name:"oldName"},{xtype:"textfield",fieldLabel:_("dbadmin.package"),name:"package",id:e.id+"dbadmin-table-package",anchor:"100%"},{layout:"column",border:!1,anchor:"100%",items:[{columnWidth:.85,layout:"form",defaults:{msgTarget:"under"},border:!1,items:[{xtype:"textfield",fieldLabel:_("dbadmin.class"),name:"class",id:e.id+"dbadmin-table-class",anchor:"100%"}]},{columnWidth:.15,layout:"form",defaults:{msgTarget:"qtip"},style:{marginTop:"5px"},border:!1,items:[{xtype:"button",text:'<i class="icon icon-magic"></i>',tooltip:_("dbadmin.table_set_class"),id:e.id+"-getclass-button",cls:"get-class-button",scope:this,anchor:"100%",handler:function(){this.getClass(this.config)}}]}]}]},getClass:function(t){var e=Ext.getCmp(t.id+"dbadmin-table-name").getValue("name"),i=Ext.getCmp(t.id+"dbadmin-table-package").getValue("package");MODx.Ajax.request({url:dbAdmin.config.connectorUrl,params:{action:"mgr/tables/setclass",name:e,package:i},listeners:{success:{fn:function(e){Ext.getCmp(t.id+"dbadmin-table-package").setValue(e.object.package||""),Ext.getCmp(t.id+"dbadmin-table-class").setValue(e.object.class||"")},scope:this},failure:{fn:function(e){},scope:this}}})}}),Ext.reg("dbadmin-table-window-update",dbAdmin.window.UpdateTable),dbAdmin.grid.Tables=function(e){(e=e||{}).id||(e.id="dbadmin-grid-tables"),this.sm=new Ext.grid.CheckboxSelectionModel,Ext.applyIf(e,{url:dbAdmin.config.connectorUrl,primaryKey:"name",sm:this.sm,fields:["name","class","package","type","rows","collation","size","actions"],columns:[this.sm,{header:_("dbadmin.table"),dataIndex:"name",sortable:!0,editable:!0,width:300},{header:_("dbadmin.class"),dataIndex:"class",sortable:!0,width:150},{header:_("dbadmin.package"),dataIndex:"package",sortable:!1,hidden:!0,width:100},{header:_("dbadmin.table_type"),dataIndex:"type",sortable:!1,fixed:!0,width:100},{header:_("dbadmin.table_collation"),dataIndex:"collation",sortable:!1,width:100},{header:_("dbadmin.table_rows"),dataIndex:"rows",sortable:!1,menuDisabled:!0,fixed:!0,width:70},{header:_("dbadmin.table_size"),dataIndex:"size",sortable:!1,menuDisabled:!0,fixed:!0,width:90},{header:_("dbadmin.table_actions"),dataIndex:"actions",renderer:dbAdmin.utils.renderActions,sortable:!1,width:130,fixed:!0}],tbar:this.getTopBar(e),baseParams:{action:"mgr/tables/getlist"},listeners:{rowDblClick:function(e,t,i){t=e.store.getAt(t);this.viewTable(e,i,t)}},viewConfig:{autoFill:!0,enableRowBody:!0,forceFit:!0,scrollOffset:0},paging:!0,pageSize:25,remoteSort:!0,autoHeight:!0,showActionsColumn:!1}),dbAdmin.grid.Tables.superclass.constructor.call(this,e),e.autosave&&this.on("afteredit",this.saveRecord,this),this.store.on("load",function(){this._getSelectedIds().length&&this.getSelectionModel().clearSelections()},this)},Ext.extend(dbAdmin.grid.Tables,MODx.grid.Grid,{windows:{},getMenu:function(e,t){var i=this._getSelectedIds(),e=e.getStore().getAt(t),t=dbAdmin.utils.getMenu(e.data.actions,this,i);this.addContextMenuItem(t)},exportSelected:function(e){var t,i="";if("dbadmin-db-export"===e.id)t=!0;else if((t=!1)===(i=this.getSelectedAsList()))return!1;var a=Ext.getCmp("dbadmin-panel-tables");a.el.mask(_("working")),MODx.Ajax.request({url:dbAdmin.config.connectorUrl,params:{action:"mgr/tables/export",tables:i,export_db:t},listeners:{success:{fn:function(e){a.el.unmask(),location.href=dbAdmin.config.connectorUrl+"?action=mgr/tables/download&name="+e.object.name+"&HTTP_MODAUTH="+MODx.siteId},scope:this},failure:{fn:function(e){a.el.unmask(),MODx.msg.alert(_("error"),e.message)},scope:this}}})},viewTable:function(e,t,i){var n=void 0!==i?i.data:this.menu.record;MODx.Ajax.request({url:dbAdmin.config.connectorUrl,params:{action:"mgr/table/getfields",table:n.name},listeners:{success:{fn:function(e){for(var t=e.fields,i=new Ext.grid.ColumnModel({columns:[],defaults:{sortable:!0,menuDisabled:!0,editable:""!==n.class,editor:{xtype:"textfield"},width:150}}),a=0;a<t.length;a++){switch(i.columns[a]={header:t[a].name,dataIndex:t[a].name},t[a].type){case"string":i.columns[a].editor={xtype:"textarea"},i.columns[a].width=300;break;case"number":i.columns[a].width=100;break;case"actions":i.columns[a].header='<i class="icon icon-cog"></i>',i.columns[a].sortable=!1,i.columns[a].width=50,i.columns[a].renderer=dbAdmin.utils.renderActions,i.columns[a].fixed=!0,i.columns[a].editable=!1}"id"===t[a].name&&(i.columns[a].width=50,i.columns[a].fixed=!0)}i.columns[0].menuDisabled=!1,this.dataGridTable&&this.dataGridTable.destroy(),this.dataGridTable=MODx.load({xtype:"dbadmin-table-data-window",table:n.name,class:n.class,package:n.package,gridFields:t,gridColumns:i}),this.dataGridTable.show(Ext.EventObject.target)},scope:this},failure:{fn:function(e){MODx.msg.alert(_("error"),e.message)},scope:this}}})},updateTable:function(e,t){var i=this.getSelectionModel().getSelected();if(void 0!==i)this.menu.record=i.data;else if(!this.menu.record)return!1;i.data.oldName=i.data.name,this.updateWindow||(this.updateWindow=MODx.load({xtype:"dbadmin-table-window-update",cls:"modx"+dbAdmin.config.modxversion,listeners:{success:{fn:function(){this.refresh()},scope:this}}})),this.updateWindow.reset(),this.updateWindow.setValues(i.data),this.updateWindow.show(t.target)},selectQuery:function(){var t=this.getSelectionModel().getSelected();if(void 0!==t)this.menu.record=t.data;else if(!this.menu.record)return!1;return MODx.Ajax.request({url:dbAdmin.config.connectorUrl,params:{action:"mgr/table/getfields",table:t.data.name,forselect:1},listeners:{success:{fn:function(e){e="SELECT "+(e.fields||"*")+" FROM `"+t.data.name+"`";Ext.getCmp("dbadmin-sql-query").setValue(e),Ext.getCmp("dbadmin-tabpanel").setActiveTab("dbadmin-sql-tab")},scope:this},failure:{fn:function(e){},scope:this}}}),!0},removeTable:function(){var e=this.getSelectionModel().getSelected();if(void 0!==e)this.menu.record=e.data;else if(!this.menu.record)return!1;e=e.data.name;return MODx.msg.confirm({title:_("dbadmin.table_remove"),text:_("dbadmin.table_remove_confirm"),url:this.config.url,params:{action:"mgr/table/remove",name:e},listeners:{success:{fn:function(){this.refresh()},scope:this}}}),!0},removeSelected:function(){var e=this.getSelectedAsList();return!1!==e&&(MODx.msg.confirm({title:1<e.split(",").length?_("dbadmin.tables_remove"):_("dbadmin.table_remove"),text:1<e.split(",").length?_("dbadmin.tables_remove_confirm"):_("dbadmin.table_remove_confirm"),url:this.config.url,params:{action:"mgr/tables/remove",tables:e},listeners:{success:{fn:function(){this.refresh()},scope:this}}}),!0)},truncateSelected:function(){var e=this.getSelectedAsList();return!1!==e&&(MODx.msg.confirm({title:1<e.split(",").length?_("dbadmin.tables_truncate"):_("dbadmin.table_truncate"),text:1<e.split(",").length?_("dbadmin.tables_truncate_confirm"):_("dbadmin.table_truncate_confirm"),url:this.config.url,params:{action:"mgr/tables/truncate",tables:e},listeners:{success:{fn:function(){this.refresh()},scope:this}}}),!0)},getTopBar:function(e){return[{text:_("dbadmin.db_export"),id:"dbadmin-db-export",handler:this.exportSelected,scope:this},{text:_("bulk_actions"),menu:[{text:'<i class="icon icon-download"></i> '+_("dbadmin.selected_export"),id:"dbadmin-menu-selected-export",handler:this.exportSelected,style:{padding:"3px 10px !important;"},scope:this},{text:'<i class="icon icon-eraser"></i> '+_("dbadmin.selected_truncate"),id:"dbadmin-menu-selected-truncate",handler:this.truncateSelected,scope:this},{text:'<i class="icon icon-trash-o"></i> '+_("dbadmin.selected_remove"),id:"dbadmin-menu-selected-remove",handler:this.removeSelected,scope:this}]},"->",{xtype:"textfield",name:"query",width:200,id:e.id+"-search-field",emptyText:_("dbadmin.grid_search"),listeners:{render:{fn:function(e){e.getEl().addKeyListener(Ext.EventObject.ENTER,function(){this.search(e)},this)},scope:this}}},{xtype:"button",id:e.id+"-search-clear",text:'<i class="icon icon-times"></i>',listeners:{click:{fn:this.clearSearch,scope:this}}}]},onClick:function(e){var t=e.getTarget();if("SPAN"===t.nodeName){var i=this.getSelectionModel().getSelected();if(void 0!==i){var a,t=t.dataset.action;if("showMenu"===t)return a=this.getStore().find("id",i.id),this._showMenu(this,a,e);if("function"==typeof this[t])return this.menu.record=i.data,this[t](this,e)}}return this.processEvent("click",e)},_getSelectedIds:function(){var e,t=[],i=this.getSelectionModel().getSelections();for(e in i)i.hasOwnProperty(e)&&t.push(i[e].name);return t},search:function(e){return this.getStore().baseParams.query=e.getValue(),this.getBottomToolbar().changePage(1),this.refresh(),!0},clearSearch:function(){return this.getStore().baseParams.query="",Ext.getCmp(this.config.id+"-search-field").setValue(""),this.getBottomToolbar().changePage(1),this.refresh(),!0}}),Ext.reg("dbadmin-grid-tables",dbAdmin.grid.Tables),dbAdmin.panel.Sql=function(e){(e=e||{}).params={},Ext.applyIf(e,{title:_("dbadmin.sql"),layout:"form",id:"dbadmin-sql-tab",items:[{xtype:"panel",id:"dbadmin-sql-panel",items:[{html:_("dbadmin.enter_sql_query"),cls:"panel-desc",style:{margin:"15px 0"}},{xtype:Ext.ComponentMgr.types["modx-texteditor"]?"modx-texteditor":"textarea",mimeType:"text/x-sql",hideLabel:!0,name:"query",style:{margin:"0 15px",resize:"vertical"},id:"dbadmin-sql-query",height:180,width:"auto",minHeight:100},{xtype:"toolbar",style:{backgroundColor:"transparent",borderColor:"transparent",margin:"10px 15px 10px 13px"},items:[{xtype:"button",id:"dbadmin-execute-query-btn",text:_("dbadmin.execute"),tooltip:"Ctrl+Enter",tooltipType:"title",listeners:{click:function(){var i=Ext.getCmp("dbadmin-sql-panel"),e=Ext.getCmp("dbadmin-sql-query");if(!e.getValue().replace(/^\s+/g,""))return!1;var a=Ext.getCmp("dbadmin-outputtype").getValue();i.el.mask(_("working")),MODx.Ajax.request({url:dbAdmin.config.connectorUrl,params:{action:"mgr/sql/execute",outputType:a,query:e.getValue()},listeners:{success:{fn:function(e){i.el.unmask();var t="var_export"===a?"<?php\n//":"";e.select?0===e.number?t+=_("dbadmin.rows_number")+"0":t+=_("dbadmin.rows_number")+e.number+"\n\n"+e.data:t=_("dbadmin.sql_executed_success"),Ext.getCmp("dbadmin-sql-query-result").setValue(t)}},failure:{fn:function(e){i.el.unmask(),MODx.form.Handler.showError=function(){return!1},Ext.getCmp("dbadmin-sql-query-result").setValue(e.message)}}}})}}},{xtype:"button",id:"dbadmin-clear-btn",text:_("dbadmin.clear"),listeners:{click:function(){Ext.getCmp("dbadmin-sql-query").setValue(""),Ext.getCmp("dbadmin-sql-query-result").setValue("")}}},"->",{xtype:"displayfield",value:_("dbadmin.output_type"),style:{fontSize:"13px"}},{xtype:"dbadmin-output-types",fieldLabel:_("dbadmin.output_type"),name:"outputType",id:"dbadmin-outputtype",value:"var_export"}]},{xtype:Ext.ComponentMgr.types["modx-texteditor"]?"modx-texteditor":"textarea",mimeType:"application/x-php",hideLabel:!0,name:"query_result",style:{margin:"10px 15px 15px",resize:"vertical"},id:"dbadmin-sql-query-result",height:360,width:"auto",minHeight:200,readOnly:!0}]}],keys:[{key:Ext.EventObject.ENTER,ctrl:!0,scope:this,fn:function(){Ext.getCmp("dbadmin-execute-query-btn").fireEvent("click")}}]}),dbAdmin.panel.Sql.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.panel.Sql,MODx.Panel),Ext.reg("dbadmin-panel-sql",dbAdmin.panel.Sql),dbAdmin.window.Data=function(e){(e=e||{}).id||(e.id="dbadmin-table-data-window"),Ext.applyIf(e,{title:_("dbadmin.table")+" `"+e.table+"`",width:1200,maxHeight:800,autoHeight:!0,autoScroll:!0,stateful:!1,items:[{xtype:"dbadmin-grid-table-data",fields:e.gridFields,columns:e.gridColumns,class:e.class,package:e.package,style:{"margin-top":"15px"},showActionsColumn:!1,baseParams:{action:"mgr/table/getdata",table:e.table,class:e.class,package:e.package}}],buttons:[{text:_("close"),id:"dbadmin-table-data-window-close-btn",handler:function(){this.hide()},scope:this}]}),dbAdmin.window.Data.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.window.Data,MODx.Window),Ext.reg("dbadmin-table-data-window",dbAdmin.window.Data),dbAdmin.grid.Data=function(e){(e=e||{}).id||(e.id="dbadmin-grid-table-data"),Ext.applyIf(e,{url:dbAdmin.config.connectorUrl,viewConfig:{autoFill:!1,enableRowBody:!0,forceFit:!1,scrollOffset:20},autosave:""!==e.class,autoWidth:!0,autoScroll:!0,paging:!0,pageSize:10,remoteSort:!0}),dbAdmin.grid.Data.superclass.constructor.call(this,e),e.autosave&&this.on("afteredit",this.saveRecord,this),this.store.on("load",function(){var e;this.getStore().getTotalCount()<10&&((e=Ext.getCmp("dbadmin-table-data-window")).autoHeight=!0,e.setHeight(300))},this)},Ext.extend(dbAdmin.grid.Data,MODx.grid.Grid,{saveRecord:function(t){if(t.originalValue===t.value.replace(/^\s+/g,""))return t.record.reject(),!1;var e=Ext.util.JSON.encode(t.record.data);MODx.Ajax.request({url:this.config.url,params:{action:"mgr/table/updatefromgrid",data:e,class:this.config.class,package:this.config.package},listeners:{success:{fn:function(e){t.record.commit(),this.refresh(),this.fireEvent("afterAutoSave",e)},scope:this},failure:{fn:function(e){t.record.reject(),this.fireEvent("afterAutoSave",e)},scope:this}}})},removeRow:function(){var e=this.getSelectionModel().getSelected();if(void 0!==e)this.menu.record=e.data;else if(!this.menu.record)return!1;e=Ext.util.JSON.encode(this.menu.record);return MODx.msg.confirm({title:_("dbadmin.row_remove"),text:_("dbadmin.row_remove_confirm"),url:this.config.url,params:{action:"mgr/table/removerow",data:e,class:this.config.class,package:this.config.package},listeners:{success:{fn:function(){this.refresh()},scope:this}}}),!0},onClick:function(e){var t=e.getTarget();if("SPAN"===t.nodeName){var i=this.getSelectionModel().getSelected();if(void 0!==i){var a,t=t.dataset.action;if("showMenu"===t)return a=this.getStore().find("id",i.id),this._showMenu(this,a,e);if("function"==typeof this[t])return this.menu.record=i.data,this[t](this,e)}}return this.processEvent("click",e)}}),Ext.reg("dbadmin-grid-table-data",dbAdmin.grid.Data),dbAdmin.page.Home=function(e){e=e||{},Ext.applyIf(e,{components:[{xtype:"dbadmin-panel-home"}]}),dbAdmin.page.Home.superclass.constructor.call(this,e)},Ext.extend(dbAdmin.page.Home,MODx.Component),Ext.reg("dbadmin-page-home",dbAdmin.page.Home);