<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'license' => 'GNU GENERAL PUBLIC LICENSE
   Version 2, June 1991
--------------------------

Copyright (C) 1989, 1991 Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.

Preamble
--------

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation\'s software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author\'s protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors\' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone\'s free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.


GNU GENERAL PUBLIC LICENSE
TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
---------------------------------------------------------------

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program\'s
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients\' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

NO WARRANTY
-----------

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

---------------------------
END OF TERMS AND CONDITIONS',
    'readme' => '--------------------
Snippet: Login
--------------------
- Version: 1.9.8
- Since: June 21, 2010
- Author: Jason Coward <jason@modx.com>,
        Shaun McCormick <shaun+login@modx.com>

This component loads a simple login and logout form. It also comes packaged
with ForgotPassword and ResetPassword snippets, which allow the user to put
in their username or email to receive a confirmation email which will reset
their password.

Example for Login:
```
[[!Login]]
```

You can also specify the template:

```
[[!Login? &tpl=`myLoginChunk`]]
```

See the snippet properties for more options.

--------------
ForgotPassword
--------------

To use the password retrieval functionality, first create the Resource the
user will log in to should they click on the confirmation email, and put
the Reset Password snippet in. Tell it what Resource the Login snippet is
in - or where you\'d like it to provide a link back to:

```
[[ResetPassword? &loginResourceId=`72`]]
```

Then create another resource with the Forgot Password snippet, and tell it
what Resource the Reset snippet is in:

```
[[!ForgotPassword? &resetResourceId=`123`]]
```

--------
Register
--------

To use the Register snippet, simply place the Snippet in the Resource where
your HTML register form is. (A default one called lgnRegisterFormTpl has
been provided.). This snippet also requires Activation by the User, so they
will get an email in their inbox regarding their signup.

In your form field names, you can use validation filters to validate your
fields. They are separated with the colon : symbol. Example:

```
<input type="password" name="password:required:minLength=6" id="password" value="[[+password]]" />
```

will require that the password field not be empty, and have a minimum
length of 6 chars. You can encapsulate validator params (6 here) with ` if
the param has spaces in the name. The default validators provided are:

```
required
blank
email
password_confirm=`nameOfPasswordField`
minLength=`123`
maxLength=`123`
minValue=`123`
maxValue=`123`
```

You can also do custom validators by creating a Snippet and using that as
the validator name. Example: We create a Snippet called \'equalTo\' and
on our field, we set:

```
<input type="text" name="field:equalTo=`123`" id="field" />
```

Now, in our snippet, our code would look like so:

```
<?php
if ($scriptProperties[\'value\'] !== $scriptProperties[\'param\']) {
    return \'Value not equal to: \'.$scriptProperties[\'param\'];
}
return true;
?>
```

Returning true will make the field valid. Any other return value will
be the error message. Snippets get passed the following parameters:

- key: The name of the field.
- value: The value of the field.
- param: The parameter, if applicable, passed to the validator.
- type: The name of the validator.
- validator: A reference to the lgnValidator instance.

See the Snippet Properties and the [MODX Docs](https://docs.modx.com/extras/revo/login) for more options.

Thanks,
Jason Coward & Shaun McCormick
MODX, LLC
',
    'changelog' => 'Changelog for Login
===================

Login 1.9.10
------------------------------------
- Log error if mail was not sent [#174]
- Switched translation to Weblate and removed not translated/less translated lexicon

Login 1.9.9
------------------------------------
- Fix validate email addresses in Register [#143]

Login 1.9.8
------------------------------------
- Allow persistParams when redirectUnsetDefaultParams is true [#157]
- Parse file based chunks [#167]
- Prevent directory traversal in the username when register a new user
- Fix logging \'Could not load package metadata for package login.\' during install
- Update Translations

Login 1.9.7
------------------------------------
- Generate the password directly with modx->user->generatePassword()
- Make it possible to set the usergroup rank when register a new user [#135]
- Set an action in the default password reset form [#134]
- Update Translations

Login 1.9.6
------------------------------------
- Register snippet PII improvements [#130]
- JSON responses for the Login controller/snippet [#121]
- Use Crowdin for translations: https://crowdin.com/project/modx-login
- Update Translations [#132]
- Use $modx->user->generatePassword for generating passwords [#131]
- Escape MODX tags after htmlspecialchars because of the ampersand sign

Login 1.9.5
------------------------------------
- Fix ResetPassword passing null instead of an array to getChunk
- Remove hash_class, salt and sessionid from placeholders
- Prevent potential XSS in placeholders
- Added two missing default template chunks
- Fixing a charset issue in some language files
- Fixing email validation [#110]
- Disable User/E-mail Enumeration in ForgotPassword snippet by an empty sentTpl property (default)
- New jsonResponse property for returning a JSON by the Register snippet (for an AJAX call response)
- Possibility to reset the registration fields after successful registration

Login 1.9.4
------------------------------------
- Disable User/E-mail Enumeration
- Enable login via email
- Convert deprecated ereg functions to preg_* [#86]
- Fixing error placeholders with empty placeholderPrefix
- Fixing recoverable error, Argument 2 to getChunk() must be of the type array, null given [#87]

Login 1.9.3
------------------------------------
- Added activePage property to ConfirmRegister controller
- Added danish language files
- Normalize placeholder prefix usage
- Improved PHP7 compatibility
- Added loggedinResourceId and loggedoutResourceId to the Login controller
- Fix errors with square brackets in changed password
- Add confirm password and password length validation messages to the field error placeholders too
- Fill lu/lp placeholders in the change password form
- Added hidden lu/lp fields to the lgnResetPassChangePassTpl chunk
- Fix for array fields in Register/Profile/UpdateProfile snippet

Login 1.9.2
------------------------------------
- Fix sending register activation email
- Fix ConfirmRegister processor

Login 1.9.1
------------------------------------
- [[!+error.message]] returns detailed error
- [#42] Fixed URL encoding/decoding
- Sanitise Login placeholders
- Fixed namespace paths

Login 1.9.0
------------------------------------
- Expired/used password reset link notification
- Added autoLogin and forceChangePassword to ResetPassword snippet
- Added autoLogin param to Register snippet
- Improved password reset functionality
- Update form fields with new values when reloadOnSuccess=0
- Replace parseChunk with getChunk
- Added Arabic lexicons
- Fixed invalid properties in logindictionary and updateprofile
- Added czech lexicons

Login 1.8.1
------------------------------------
- Add password strength algorithm and checking properties to Register, via &ensurePasswordStrength property

Login 1.8.0
------------------------------------
- [#5946] Add ability to set User Group for a new user via the &usergroupsField property
- [#7520] Fix bug with ConfirmRegister logging the user in as anonymous

Login 1.7.3
------------------------------------
- [#7035] Fix regression error with email field in Register snippet

Login 1.7.2
------------------------------------
- [#6194] Fix issue with UpdateProfile when specifying the non-active user to update
- [#6538] Add removeExpiredRegistrations property to Register snippet for handling expired, unactivated registrations
- [#6256] Ensure Register respects passwordField and emailField properties
- [#6288] Fix error message display in ChangePassword

Login 1.7.1
------------------------------------
- [#5947] Fix issue with Profile with unauthenticated users
- [#5979] Fix issue with ConfirmRegister and non-FURL sites
- [#5734] Add &allowedFields to Register to allow restricting of submitted fields to a specific set
- [#6010] Fix typo in UpdateProfile mismatching ID of profile to internalKey
- [#5961] Add &trimPassword to automatically trim whitespace from submitted passwords
- Add &generatePassword to automatically generate a password instead of having to provide one manually
- [#6146] Add &validatePassword to Register to allow for manual password generation
- [#5969] Add &user property to UpdateProfile to allow specifying user to update

Login 1.7.0
------------------------------------
- [#49] Update reCaptcha URLs
- [#5793] Add errTpl and errTplType properties to ForgotPassword
- [#5823] Fix issue where postHooks did not have fields available
- [#5797] Fix issue where &authenticate was not respected in ConfirmRegister snippet
- [#5796] Fix issue where errors could appear twice if user used validators on username/email/password fields
- Add ActiveUsers snippet that shows a list of active, logged-in users
- Add file-based hooks to Login hook calls
- Complete OOP refactoring to provide more stable development and better code isolation
- Add unit test framework and over 30 tests
- Add alternative plaintext email option for ability to send both html and plaintext in emails
- [#5166] Add additional sanity decoding to ConfirmRegister processing

Login 1.6.5
------------------------------------
- [#5176] Fix issue with Registration in Revo 2.0 installations
- Fix issue with some error messages not being wrapped with errTpl
- Email validator now only checks for email validation, not required status
- [#5166] Add additional sanity decoding to ConfirmRegister processing

Login 1.6.4
------------------------------------
- [#3588] Add &allowedFields and &allowedExtendedFields to UpdateProfile to restrict fields that are updated
- [#4744] Add &redirectToOnFailedAuth parameter for redirecting to a separate page on failed logins
- [#3263] Remove duplicate error spans in validator output

Login 1.6.3
------------------------------------
- Better support for checkboxes/radios/bracketed fields in login validator
- [#5088] Fix issue with ChangePassword &validateOldPassword and Revo 2.1.1

Login 1.6.2
------------------------------------
- [#4844] Automatically trim trailing whitespace/newlines in validator calls
- [#4843] Fix issue with sentTplType not being respected in ForgotPassword
- [#4936] Fix issue in ForgotPassword that occurred if no user was found with that username
- [#5019] Add backwards compatibility for Revo 2.0.x users in ResetPassword
- Fix reference to $this->modx->lexicon in Login Snippet

Login 1.6.0/1
------------------------------------
- [#4886] Fix issue with variable variable in main login class when loading hooks
- [#4487] Prevent usage of mb_ereg if not installed
- [#3500] Fix issues with inline tplType params in Login snippets
- [#4545] Fix issue with OnBeforeUserActivate event
- Revolution 2.1 support, specifically with the password changes

Login 1.5.3
------------------------------------
- Add preHooks to ForgotPassword snippet
- Fix issue that occurs when Login and Register forms are on same page with math register hook

Login 1.5.2
------------------------------------
- [#3330] Add sanity checks to prevent possible submitVar data adding in UpdateProfile
- Add support for moderation of users when done in a prehook
- Add support for redirectBackParams that can send encoded data through a login/registration process
- Add a generic validation error in Register to allow for general messages
- Ensure preHooks run before password validation in ChangePassword snippet
- Fix issue with placeholderPrefix in UpdateProfile snippet

Login 1.5.1
------------------------------------
- [#44] Fix bug with login validator, &validate parameter
- [#40] Fix issue with syncUsername in UpdateProfile
- [#42] Respect allow_multiple_emails setting that prevents users with same email addresses
- [#43] Add workaround for xPDO bug with NULL fields in modUserProfile
- Trim each hook specification in hooks calls
- [#28] Fixed validator issue in UpdateProfile
- Added redirectTo and redirectParams on ForgotPassword snippet
- Updated events in ResetPassword snippet to pass user object
- Fixed UpdateProfile to properly update user obj so derivative User classes can manage profile updates

Login 1.5.0
------------------------------------
- Fixed security vulnerability
- Added authenticate and authenticateContexts to ConfirmRegister to allow for authentication after confirming registration
- Fixed persisting request alias params issue in ConfirmRegister
- [#15] Added ability to assign roles when using &usergroups in Register, ie: &usergroups=`my-group-name:Member`
- Added math hook to Register, allowing anti-spam math field measure
- Added fix to allow overriding of class_key for new users in Register

Login 1.4.0
------------------------------------
- Added redirectBack to Register, Login and ConfirmRegister that allows dynamic redirection handling for other forms needing login/registration
- Added redirectTo, redirectParams to ConfirmRegister that will redirect after successful confirmation
- Added persistParams to Register snippet, useful for shopping cart implementations to persist parameters across the registration process
- [#27] Fixed issue with activationEmail always overriding normal email
- [#29] Added loginResourceParams, logoutResourceParams, which allows attaching REQUEST parameters to login/logout redirection URLs
- Added changelog to build
- [#26],[#14] Added activationEmail property for better handling of middle men in activation steps

Login 1.3.2-pl
------------------------------------
- [#25] Added isLoggedIn snippet for checking auth status
- [#24] Fixed issue where inactive user could re-register
- Fixed issue with embedded chunk type display
- Fixed issue with redirects and non-FURLs on Register snippet

Login 1.3.1-pl (October 15, 2010)
------------------------------------
- Fixed issue with Login snippet on invalid logins

Login 1.3.0-pl (October 14, 2010)
------------------------------------
- Modified experimental multi-context support to use new login processor add_contexts parameter
- Added ChangePassword snippet for changing passwords in the front-end
- Fixed bugs with usernameField property, now works as expected
- Added Dutch translation

Login 1.2.0
------------------------------------
- Fixed issues with placement of prehooks and such
- Added excludeExtended property to Register, UpdateProfile snippets to allow for excluding fields from extended fields
- Added new hook API methods for easier setting/retrieving of fields
- Added experimental multiple-context login support
- Fixed bug in login snippet with hard-coded action keys
- Added support to set subject in ForgotPassword email
- Added reCaptcha support to login form via a preHook
- Added preHooks and postHooks ability to Login snippet
- i18n of snippet properties

Login 1.1.0
------------------------------------
- Added Profile snippet, which outputs Profile data of a User in placeholders
- Added &useExtended to UpdateProfile/Register, which allows users to set additional fields passed to be set in extended column
- Fixed bug in UpdateProfile where validators were broken

Login 1.0.3
------------------------------------
- Fixed bug where logout link generation was ignorant of xhtml_urls setting
- Fixed bug where ForgotPassword was sending invalid confirmUrl
- Added preHooks and postHooks properties for doing pre and post register scripting to UpdateProfile snippet
- Added preHooks and postHooks properties for doing pre and post register scripting to Register snippet
- Added syncUsername property to UpdateProfile snippet
- Fixed bug with embedded output in Login snippet
- Added Russian translation

Login 1.0.2
------------------------------------
- Updated copyright information
- Ensure username,password and email are always passed to register snippet to prevent blank logins

Login 1.0.1
------------------------------------
- Consolidated elements into own dir
- Added extra checks and fixes to lgnValidator class
- Added UpdateProfile snippet to enable updating of profile from front-end

Login 1.0.0
------------------------------------
- [#ADDON-129] Added name to default Register form
- [#ADDON-106] Fixed incorrect plugin event invoking
- [#ADDON-107] Added missing lexicon entry register.password_confirm
- [#ADDON-103] Fixed context-specific issue with register email
- [#ADDON-118] Force lexicon topic to load on lgnRegisterForm
- Fixed alias issue in ForgotPassword snippet
- Added changelog.txt
',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modNamespace',
      'guid' => 'b90b3bc49fcdaae8c0593c57616796c5',
      'native_key' => 'login',
      'filename' => 'modNamespace/97fea9aac0b476d888eff25a7daec135.vehicle',
      'namespace' => 'login',
    ),
    1 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '8141d4a9d2fb898fe541fb359025146e',
      'native_key' => 'login.forgot_password_email_subject',
      'filename' => 'modSystemSetting/8290a50f2f2b2bc129809f7b1dbc8da1.vehicle',
      'namespace' => 'login',
    ),
    2 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '87a54685e942400c374948703c260578',
      'native_key' => 'recaptcha.public_key',
      'filename' => 'modSystemSetting/ad1c5d17be83749ca02f05dce7230ffd.vehicle',
      'namespace' => 'login',
    ),
    3 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '104fe04bc73db1b4e3670ffe6f5be5e6',
      'native_key' => 'recaptcha.private_key',
      'filename' => 'modSystemSetting/7e7efc0820a38f7cfd7348692a637e4b.vehicle',
      'namespace' => 'login',
    ),
    4 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'c91bd3d5943ae254df8aaa7c84ad9523',
      'native_key' => 'recaptcha.use_ssl',
      'filename' => 'modSystemSetting/278ce0bfd4d041eaf7eb15e0b9424567.vehicle',
      'namespace' => 'login',
    ),
    5 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modCategory',
      'guid' => 'f868d0be333d31b5ac2f49e560616e30',
      'native_key' => NULL,
      'filename' => 'modCategory/8c617731cda3d04f879eeb02fc732106.vehicle',
      'namespace' => 'login',
    ),
  ),
);