<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'readme' => '# modAI for MODX Revolution 3.0+

A **generative AI Extra** for MODX Revolution that helps you **create content faster** and **optimize SEO effortlessly**.

## What modAI Can Do
**Generate Content** – Quickly craft page content, blog posts, and marketing copy.  
**SEO Optimization** – Improve **meta titles, descriptions, and summaries** for better ranking.  
**Image Assistance** – Create and enhance images, **generate meaninful alt tags**, and improve accessibility.  
**Chat-Based Prompts** – Use **zero-shot or iterative chat** to refine your outputs dynamically.  

## Powerful Features
**Multi-Vendor Support** – Choose from **different AI providers** for flexibility.  
**Multiple Model Types** – Use **text models, image models, vision models, and hybrid AI** for various tasks.  
**Iterative Refinements** – Fine-tune AI-generated content through **chat-based enhancements**.  
**Seamless Integration** – Attach to **any text or image field** in MODX and works with **SEO Suite** and **Image+**.  

Perfect for **MODX users, content creators, and SEO specialists** who want to streamline their workflow!

_For additional information, read the [documentation](https://modxcms.github.io/modAI/), view the [latest announcment](https://modx.com/blog/generative-ai-content-for-modx-revolution-with-modai), or ask a question in an issue here._
',
    'license' => 'GNU Affero General Public License
=================================

_Version 3, 19 November 2007_
_Copyright © 2007 Free Software Foundation, Inc. &lt;<http://fsf.org/>&gt;_

Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.

## Preamble

The GNU Affero General Public License is a free, copyleft license for
software and other kinds of works, specifically designed to ensure
cooperation with the community in the case of network server software.

The licenses for most software and other practical works are designed
to take away your freedom to share and change the works.  By contrast,
our General Public Licenses are intended to guarantee your freedom to
share and change all versions of a program--to make sure it remains free
software for all its users.

When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
them if you wish), that you receive source code or can get it if you
want it, that you can change the software or use pieces of it in new
free programs, and that you know you can do these things.

Developers that use our General Public Licenses protect your rights
with two steps: **(1)** assert copyright on the software, and **(2)** offer
you this License which gives you legal permission to copy, distribute
and/or modify the software.

A secondary benefit of defending all users\' freedom is that
improvements made in alternate versions of the program, if they
receive widespread use, become available for other developers to
incorporate.  Many developers of free software are heartened and
encouraged by the resulting cooperation.  However, in the case of
software used on network servers, this result may fail to come about.
The GNU General Public License permits making a modified version and
letting the public access it on a server without ever releasing its
source code to the public.

The GNU Affero General Public License is designed specifically to
ensure that, in such cases, the modified source code becomes available
to the community.  It requires the operator of a network server to
provide the source code of the modified version running there to the
users of that server.  Therefore, public use of a modified version, on
a publicly accessible server, gives the public access to the source
code of the modified version.

An older license, called the Affero General Public License and
published by Affero, was designed to accomplish similar goals.  This is
a different license, not a version of the Affero GPL, but Affero has
released a new version of the Affero GPL which permits relicensing under
this license.

The precise terms and conditions for copying, distribution and
modification follow.

## TERMS AND CONDITIONS

### 0. Definitions

“This License” refers to version 3 of the GNU Affero General Public License.

“Copyright” also means copyright-like laws that apply to other kinds of
works, such as semiconductor masks.

“The Program” refers to any copyrightable work licensed under this
License.  Each licensee is addressed as “you”.  “Licensees” and
“recipients” may be individuals or organizations.

To “modify” a work means to copy from or adapt all or part of the work
in a fashion requiring copyright permission, other than the making of an
exact copy.  The resulting work is called a “modified version” of the
earlier work or a work “based on” the earlier work.

A “covered work” means either the unmodified Program or a work based
on the Program.

To “propagate” a work means to do anything with it that, without
permission, would make you directly or secondarily liable for
infringement under applicable copyright law, except executing it on a
computer or modifying a private copy.  Propagation includes copying,
distribution (with or without modification), making available to the
public, and in some countries other activities as well.

To “convey” a work means any kind of propagation that enables other
parties to make or receive copies.  Mere interaction with a user through
a computer network, with no transfer of a copy, is not conveying.

An interactive user interface displays “Appropriate Legal Notices”
to the extent that it includes a convenient and prominently visible
feature that **(1)** displays an appropriate copyright notice, and **(2)**
tells the user that there is no warranty for the work (except to the
extent that warranties are provided), that licensees may convey the
work under this License, and how to view a copy of this License.  If
the interface presents a list of user commands or options, such as a
menu, a prominent item in the list meets this criterion.

### 1. Source Code

The “source code” for a work means the preferred form of the work
for making modifications to it.  “Object code” means any non-source
form of a work.

A “Standard Interface” means an interface that either is an official
standard defined by a recognized standards body, or, in the case of
interfaces specified for a particular programming language, one that
is widely used among developers working in that language.

The “System Libraries” of an executable work include anything, other
than the work as a whole, that **(a)** is included in the normal form of
packaging a Major Component, but which is not part of that Major
Component, and **(b)** serves only to enable use of the work with that
Major Component, or to implement a Standard Interface for which an
implementation is available to the public in source code form.  A
“Major Component”, in this context, means a major essential component
(kernel, window system, and so on) of the specific operating system
(if any) on which the executable work runs, or a compiler used to
produce the work, or an object code interpreter used to run it.

The “Corresponding Source” for a work in object code form means all
the source code needed to generate, install, and (for an executable
work) run the object code and to modify the work, including scripts to
control those activities.  However, it does not include the work\'s
System Libraries, or general-purpose tools or generally available free
programs which are used unmodified in performing those activities but
which are not part of the work.  For example, Corresponding Source
includes interface definition files associated with source files for
the work, and the source code for shared libraries and dynamically
linked subprograms that the work is specifically designed to require,
such as by intimate data communication or control flow between those
subprograms and other parts of the work.

The Corresponding Source need not include anything that users
can regenerate automatically from other parts of the Corresponding
Source.

The Corresponding Source for a work in source code form is that
same work.

### 2. Basic Permissions

All rights granted under this License are granted for the term of
copyright on the Program, and are irrevocable provided the stated
conditions are met.  This License explicitly affirms your unlimited
permission to run the unmodified Program.  The output from running a
covered work is covered by this License only if the output, given its
content, constitutes a covered work.  This License acknowledges your
rights of fair use or other equivalent, as provided by copyright law.

You may make, run and propagate covered works that you do not
convey, without conditions so long as your license otherwise remains
in force.  You may convey covered works to others for the sole purpose
of having them make modifications exclusively for you, or provide you
with facilities for running those works, provided that you comply with
the terms of this License in conveying all material for which you do
not control copyright.  Those thus making or running the covered works
for you must do so exclusively on your behalf, under your direction
and control, on terms that prohibit them from making any copies of
your copyrighted material outside their relationship with you.

Conveying under any other circumstances is permitted solely under
the conditions stated below.  Sublicensing is not allowed; section 10
makes it unnecessary.

### 3. Protecting Users\' Legal Rights From Anti-Circumvention Law

No covered work shall be deemed part of an effective technological
measure under any applicable law fulfilling obligations under article
11 of the WIPO copyright treaty adopted on 20 December 1996, or
similar laws prohibiting or restricting circumvention of such
measures.

When you convey a covered work, you waive any legal power to forbid
circumvention of technological measures to the extent such circumvention
is effected by exercising rights under this License with respect to
the covered work, and you disclaim any intention to limit operation or
modification of the work as a means of enforcing, against the work\'s
users, your or third parties\' legal rights to forbid circumvention of
technological measures.

### 4. Conveying Verbatim Copies

You may convey verbatim copies of the Program\'s source code as you
receive it, in any medium, provided that you conspicuously and
appropriately publish on each copy an appropriate copyright notice;
keep intact all notices stating that this License and any
non-permissive terms added in accord with section 7 apply to the code;
keep intact all notices of the absence of any warranty; and give all
recipients a copy of this License along with the Program.

You may charge any price or no price for each copy that you convey,
and you may offer support or warranty protection for a fee.

### 5. Conveying Modified Source Versions

You may convey a work based on the Program, or the modifications to
produce it from the Program, in the form of source code under the
terms of section 4, provided that you also meet all of these conditions:

* **a)** The work must carry prominent notices stating that you modified
  it, and giving a relevant date.
* **b)** The work must carry prominent notices stating that it is
  released under this License and any conditions added under section 7.
  This requirement modifies the requirement in section 4 to
  “keep intact all notices”.
* **c)** You must license the entire work, as a whole, under this
  License to anyone who comes into possession of a copy.  This
  License will therefore apply, along with any applicable section 7
  additional terms, to the whole of the work, and all its parts,
  regardless of how they are packaged.  This License gives no
  permission to license the work in any other way, but it does not
  invalidate such permission if you have separately received it.
* **d)** If the work has interactive user interfaces, each must display
  Appropriate Legal Notices; however, if the Program has interactive
  interfaces that do not display Appropriate Legal Notices, your
  work need not make them do so.

A compilation of a covered work with other separate and independent
works, which are not by their nature extensions of the covered work,
and which are not combined with it such as to form a larger program,
in or on a volume of a storage or distribution medium, is called an
“aggregate” if the compilation and its resulting copyright are not
used to limit the access or legal rights of the compilation\'s users
beyond what the individual works permit.  Inclusion of a covered work
in an aggregate does not cause this License to apply to the other
parts of the aggregate.

### 6. Conveying Non-Source Forms

You may convey a covered work in object code form under the terms
of sections 4 and 5, provided that you also convey the
machine-readable Corresponding Source under the terms of this License,
in one of these ways:

* **a)** Convey the object code in, or embodied in, a physical product
  (including a physical distribution medium), accompanied by the
  Corresponding Source fixed on a durable physical medium
  customarily used for software interchange.
* **b)** Convey the object code in, or embodied in, a physical product
  (including a physical distribution medium), accompanied by a
  written offer, valid for at least three years and valid for as
  long as you offer spare parts or customer support for that product
  model, to give anyone who possesses the object code either **(1)** a
  copy of the Corresponding Source for all the software in the
  product that is covered by this License, on a durable physical
  medium customarily used for software interchange, for a price no
  more than your reasonable cost of physically performing this
  conveying of source, or **(2)** access to copy the
  Corresponding Source from a network server at no charge.
* **c)** Convey individual copies of the object code with a copy of the
  written offer to provide the Corresponding Source.  This
  alternative is allowed only occasionally and noncommercially, and
  only if you received the object code with such an offer, in accord
  with subsection 6b.
* **d)** Convey the object code by offering access from a designated
  place (gratis or for a charge), and offer equivalent access to the
  Corresponding Source in the same way through the same place at no
  further charge.  You need not require recipients to copy the
  Corresponding Source along with the object code.  If the place to
  copy the object code is a network server, the Corresponding Source
  may be on a different server (operated by you or a third party)
  that supports equivalent copying facilities, provided you maintain
  clear directions next to the object code saying where to find the
  Corresponding Source.  Regardless of what server hosts the
  Corresponding Source, you remain obligated to ensure that it is
  available for as long as needed to satisfy these requirements.
* **e)** Convey the object code using peer-to-peer transmission, provided
  you inform other peers where the object code and Corresponding
  Source of the work are being offered to the general public at no
  charge under subsection 6d.

A separable portion of the object code, whose source code is excluded
from the Corresponding Source as a System Library, need not be
included in conveying the object code work.

A “User Product” is either **(1)** a “consumer product”, which means any
tangible personal property which is normally used for personal, family,
or household purposes, or **(2)** anything designed or sold for incorporation
into a dwelling.  In determining whether a product is a consumer product,
doubtful cases shall be resolved in favor of coverage.  For a particular
product received by a particular user, “normally used” refers to a
typical or common use of that class of product, regardless of the status
of the particular user or of the way in which the particular user
actually uses, or expects or is expected to use, the product.  A product
is a consumer product regardless of whether the product has substantial
commercial, industrial or non-consumer uses, unless such uses represent
the only significant mode of use of the product.

“Installation Information” for a User Product means any methods,
procedures, authorization keys, or other information required to install
and execute modified versions of a covered work in that User Product from
a modified version of its Corresponding Source.  The information must
suffice to ensure that the continued functioning of the modified object
code is in no case prevented or interfered with solely because
modification has been made.

If you convey an object code work under this section in, or with, or
specifically for use in, a User Product, and the conveying occurs as
part of a transaction in which the right of possession and use of the
User Product is transferred to the recipient in perpetuity or for a
fixed term (regardless of how the transaction is characterized), the
Corresponding Source conveyed under this section must be accompanied
by the Installation Information.  But this requirement does not apply
if neither you nor any third party retains the ability to install
modified object code on the User Product (for example, the work has
been installed in ROM).

The requirement to provide Installation Information does not include a
requirement to continue to provide support service, warranty, or updates
for a work that has been modified or installed by the recipient, or for
the User Product in which it has been modified or installed.  Access to a
network may be denied when the modification itself materially and
adversely affects the operation of the network or violates the rules and
protocols for communication across the network.

Corresponding Source conveyed, and Installation Information provided,
in accord with this section must be in a format that is publicly
documented (and with an implementation available to the public in
source code form), and must require no special password or key for
unpacking, reading or copying.

### 7. Additional Terms

“Additional permissions” are terms that supplement the terms of this
License by making exceptions from one or more of its conditions.
Additional permissions that are applicable to the entire Program shall
be treated as though they were included in this License, to the extent
that they are valid under applicable law.  If additional permissions
apply only to part of the Program, that part may be used separately
under those permissions, but the entire Program remains governed by
this License without regard to the additional permissions.

When you convey a copy of a covered work, you may at your option
remove any additional permissions from that copy, or from any part of
it.  (Additional permissions may be written to require their own
removal in certain cases when you modify the work.)  You may place
additional permissions on material, added by you to a covered work,
for which you have or can give appropriate copyright permission.

Notwithstanding any other provision of this License, for material you
add to a covered work, you may (if authorized by the copyright holders of
that material) supplement the terms of this License with terms:

* **a)** Disclaiming warranty or limiting liability differently from the
  terms of sections 15 and 16 of this License; or
* **b)** Requiring preservation of specified reasonable legal notices or
  author attributions in that material or in the Appropriate Legal
  Notices displayed by works containing it; or
* **c)** Prohibiting misrepresentation of the origin of that material, or
  requiring that modified versions of such material be marked in
  reasonable ways as different from the original version; or
* **d)** Limiting the use for publicity purposes of names of licensors or
  authors of the material; or
* **e)** Declining to grant rights under trademark law for use of some
  trade names, trademarks, or service marks; or
* **f)** Requiring indemnification of licensors and authors of that
  material by anyone who conveys the material (or modified versions of
  it) with contractual assumptions of liability to the recipient, for
  any liability that these contractual assumptions directly impose on
  those licensors and authors.

All other non-permissive additional terms are considered “further
restrictions” within the meaning of section 10.  If the Program as you
received it, or any part of it, contains a notice stating that it is
governed by this License along with a term that is a further
restriction, you may remove that term.  If a license document contains
a further restriction but permits relicensing or conveying under this
License, you may add to a covered work material governed by the terms
of that license document, provided that the further restriction does
not survive such relicensing or conveying.

If you add terms to a covered work in accord with this section, you
must place, in the relevant source files, a statement of the
additional terms that apply to those files, or a notice indicating
where to find the applicable terms.

Additional terms, permissive or non-permissive, may be stated in the
form of a separately written license, or stated as exceptions;
the above requirements apply either way.

### 8. Termination

You may not propagate or modify a covered work except as expressly
provided under this License.  Any attempt otherwise to propagate or
modify it is void, and will automatically terminate your rights under
this License (including any patent licenses granted under the third
paragraph of section 11).

However, if you cease all violation of this License, then your
license from a particular copyright holder is reinstated **(a)**
provisionally, unless and until the copyright holder explicitly and
finally terminates your license, and **(b)** permanently, if the copyright
holder fails to notify you of the violation by some reasonable means
prior to 60 days after the cessation.

Moreover, your license from a particular copyright holder is
reinstated permanently if the copyright holder notifies you of the
violation by some reasonable means, this is the first time you have
received notice of violation of this License (for any work) from that
copyright holder, and you cure the violation prior to 30 days after
your receipt of the notice.

Termination of your rights under this section does not terminate the
licenses of parties who have received copies or rights from you under
this License.  If your rights have been terminated and not permanently
reinstated, you do not qualify to receive new licenses for the same
material under section 10.

### 9. Acceptance Not Required for Having Copies

You are not required to accept this License in order to receive or
run a copy of the Program.  Ancillary propagation of a covered work
occurring solely as a consequence of using peer-to-peer transmission
to receive a copy likewise does not require acceptance.  However,
nothing other than this License grants you permission to propagate or
modify any covered work.  These actions infringe copyright if you do
not accept this License.  Therefore, by modifying or propagating a
covered work, you indicate your acceptance of this License to do so.

### 10. Automatic Licensing of Downstream Recipients

Each time you convey a covered work, the recipient automatically
receives a license from the original licensors, to run, modify and
propagate that work, subject to this License.  You are not responsible
for enforcing compliance by third parties with this License.

An “entity transaction” is a transaction transferring control of an
organization, or substantially all assets of one, or subdividing an
organization, or merging organizations.  If propagation of a covered
work results from an entity transaction, each party to that
transaction who receives a copy of the work also receives whatever
licenses to the work the party\'s predecessor in interest had or could
give under the previous paragraph, plus a right to possession of the
Corresponding Source of the work from the predecessor in interest, if
the predecessor has it or can get it with reasonable efforts.

You may not impose any further restrictions on the exercise of the
rights granted or affirmed under this License.  For example, you may
not impose a license fee, royalty, or other charge for exercise of
rights granted under this License, and you may not initiate litigation
(including a cross-claim or counterclaim in a lawsuit) alleging that
any patent claim is infringed by making, using, selling, offering for
sale, or importing the Program or any portion of it.

### 11. Patents

A “contributor” is a copyright holder who authorizes use under this
License of the Program or a work on which the Program is based.  The
work thus licensed is called the contributor\'s “contributor version”.

A contributor\'s “essential patent claims” are all patent claims
owned or controlled by the contributor, whether already acquired or
hereafter acquired, that would be infringed by some manner, permitted
by this License, of making, using, or selling its contributor version,
but do not include claims that would be infringed only as a
consequence of further modification of the contributor version.  For
purposes of this definition, “control” includes the right to grant
patent sublicenses in a manner consistent with the requirements of
this License.

Each contributor grants you a non-exclusive, worldwide, royalty-free
patent license under the contributor\'s essential patent claims, to
make, use, sell, offer for sale, import and otherwise run, modify and
propagate the contents of its contributor version.

In the following three paragraphs, a “patent license” is any express
agreement or commitment, however denominated, not to enforce a patent
(such as an express permission to practice a patent or covenant not to
sue for patent infringement).  To “grant” such a patent license to a
party means to make such an agreement or commitment not to enforce a
patent against the party.

If you convey a covered work, knowingly relying on a patent license,
and the Corresponding Source of the work is not available for anyone
to copy, free of charge and under the terms of this License, through a
publicly available network server or other readily accessible means,
then you must either **(1)** cause the Corresponding Source to be so
available, or **(2)** arrange to deprive yourself of the benefit of the
patent license for this particular work, or **(3)** arrange, in a manner
consistent with the requirements of this License, to extend the patent
license to downstream recipients.  “Knowingly relying” means you have
actual knowledge that, but for the patent license, your conveying the
covered work in a country, or your recipient\'s use of the covered work
in a country, would infringe one or more identifiable patents in that
country that you have reason to believe are valid.

If, pursuant to or in connection with a single transaction or
arrangement, you convey, or propagate by procuring conveyance of, a
covered work, and grant a patent license to some of the parties
receiving the covered work authorizing them to use, propagate, modify
or convey a specific copy of the covered work, then the patent license
you grant is automatically extended to all recipients of the covered
work and works based on it.

A patent license is “discriminatory” if it does not include within
the scope of its coverage, prohibits the exercise of, or is
conditioned on the non-exercise of one or more of the rights that are
specifically granted under this License.  You may not convey a covered
work if you are a party to an arrangement with a third party that is
in the business of distributing software, under which you make payment
to the third party based on the extent of your activity of conveying
the work, and under which the third party grants, to any of the
parties who would receive the covered work from you, a discriminatory
patent license **(a)** in connection with copies of the covered work
conveyed by you (or copies made from those copies), or **(b)** primarily
for and in connection with specific products or compilations that
contain the covered work, unless you entered into that arrangement,
or that patent license was granted, prior to 28 March 2007.

Nothing in this License shall be construed as excluding or limiting
any implied license or other defenses to infringement that may
otherwise be available to you under applicable patent law.

### 12. No Surrender of Others\' Freedom

If conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot convey a
covered work so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you may
not convey it at all.  For example, if you agree to terms that obligate you
to collect a royalty for further conveying from those to whom you convey
the Program, the only way you could satisfy both those terms and this
License would be to refrain entirely from conveying the Program.

### 13. Remote Network Interaction; Use with the GNU General Public License

Notwithstanding any other provision of this License, if you modify the
Program, your modified version must prominently offer all users
interacting with it remotely through a computer network (if your version
supports such interaction) an opportunity to receive the Corresponding
Source of your version by providing access to the Corresponding Source
from a network server at no charge, through some standard or customary
means of facilitating copying of software.  This Corresponding Source
shall include the Corresponding Source for any work covered by version 3
of the GNU General Public License that is incorporated pursuant to the
following paragraph.

Notwithstanding any other provision of this License, you have
permission to link or combine any covered work with a work licensed
under version 3 of the GNU General Public License into a single
combined work, and to convey the resulting work.  The terms of this
License will continue to apply to the part which is the covered work,
but the work with which it is combined will remain governed by version
3 of the GNU General Public License.

### 14. Revised Versions of this License

The Free Software Foundation may publish revised and/or new versions of
the GNU Affero General Public License from time to time.  Such new versions
will be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the
Program specifies that a certain numbered version of the GNU Affero General
Public License “or any later version” applies to it, you have the
option of following the terms and conditions either of that numbered
version or of any later version published by the Free Software
Foundation.  If the Program does not specify a version number of the
GNU Affero General Public License, you may choose any version ever published
by the Free Software Foundation.

If the Program specifies that a proxy can decide which future
versions of the GNU Affero General Public License can be used, that proxy\'s
public statement of acceptance of a version permanently authorizes you
to choose that version for the Program.

Later license versions may give you additional or different
permissions.  However, no additional obligations are imposed on any
author or copyright holder as a result of your choosing to follow a
later version.

### 15. Disclaimer of Warranty

THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM “AS IS” WITHOUT WARRANTY
OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

### 16. Limitation of Liability

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS
THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD
PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),
EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.

### 17. Interpretation of Sections 15 and 16

If the disclaimer of warranty and limitation of liability provided
above cannot be given local legal effect according to their terms,
reviewing courts shall apply local law that most closely approximates
an absolute waiver of all civil liability in connection with the
Program, unless a warranty or assumption of liability accompanies a
copy of the Program in return for a fee.

_END OF TERMS AND CONDITIONS_

## How to Apply These Terms to Your New Programs

If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
state the exclusion of warranty; and each file should have at least
the “copyright” line and a pointer to where the full notice is found.

    <one line to give the program\'s name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

Also add information on how to contact you by electronic and paper mail.

If your software can interact with users remotely through a computer
network, you should also make sure that it provides a way for users to
get its source.  For example, if your program is a web application, its
interface could display a “Source” link that leads users to an archive
of the code.  There are many ways you could offer source, and different
solutions will be better for different programs; see section 13 for the
specific requirements.

You should also get your employer (if you work as a programmer) or school,
if any, to sign a “copyright disclaimer” for the program, if necessary.
For more information on this, and how to apply and follow the GNU AGPL, see
&lt;<http://www.gnu.org/licenses/>&gt;.
',
    'changelog' => '# Changelog

This is a shortened version, [view full Changelog here](https://github.com/modxcms/modAI/blob/main/CHANGELOG.md).

## 0.13.1-pl - 2025-07-18

### Features

- Add  to the tool\'s getParameters and getPrompt methods as an argument ([931d4e1](https://github.com/modxcms/modAI/commit/931d4e1354cf1fe592acb3a5089b40c93cd61447))

### Bug Fixes

- Fix format for vision endpoint for OpenAI ([4827e6c](https://github.com/modxcms/modAI/commit/4827e6c9e2e9452d1da31fd936bcf81d171db90d))


',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modNamespace',
      'guid' => '5cc44bc85716c2bac89639114ced3380',
      'native_key' => 'modai',
      'filename' => 'MODX/Revolution/modNamespace/71e3cae691304f05c815086eac1743fe.vehicle',
    ),
    1 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '75ba3affaadfa733caa7d691f75fae6c',
      'native_key' => '75ba3affaadfa733caa7d691f75fae6c',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/4e2c268d235f6096b1eb21639a301dc8.vehicle',
    ),
    2 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '32623a105fb588e42181648c5e21981a',
      'native_key' => '32623a105fb588e42181648c5e21981a',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/e896a968111de918443a0bf7f85ab8c5.vehicle',
    ),
    3 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '37225b3668d5c282ac72018bcbe313b3',
      'native_key' => 'modai.cache.lit',
      'filename' => 'MODX/Revolution/modSystemSetting/359ad58937b20bbc27757dd8c5d46475.vehicle',
    ),
    4 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '984cebc59c05c1b7d1b36b23bf1f66a3',
      'native_key' => 'modai.init.global_chat',
      'filename' => 'MODX/Revolution/modSystemSetting/455b99699821a77c586155aa88ce8257.vehicle',
    ),
    5 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '9f5f50610c50228379c5bf4ff89299a0',
      'native_key' => 'modai.init.media_browser',
      'filename' => 'MODX/Revolution/modSystemSetting/f6f092860cd12b23e6276c626e8d17cb.vehicle',
    ),
    6 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '603562f7e95b575cef95d48f68ea4600',
      'native_key' => 'modai.api.execute_on_server',
      'filename' => 'MODX/Revolution/modSystemSetting/d00b593b55d43efaf686e4a6da4e92b4.vehicle',
    ),
    7 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '2201dba136e427c62494642c01016e63',
      'native_key' => 'modai.api.openai.key',
      'filename' => 'MODX/Revolution/modSystemSetting/21a14848fe512f48f8297ca4c0437dd7.vehicle',
    ),
    8 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '9ef6e31a670e5367759082765662f2db',
      'native_key' => 'modai.api.google.key',
      'filename' => 'MODX/Revolution/modSystemSetting/a42b42832aed880e0e799f2b5067662d.vehicle',
    ),
    9 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'c01222e50990319147ed0cb82954ee86',
      'native_key' => 'modai.api.anthropic.key',
      'filename' => 'MODX/Revolution/modSystemSetting/7d86cc5154ce5d4a47f12da121f4f550.vehicle',
    ),
    10 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'c776f3c7e551218c671b4e385dedff1a',
      'native_key' => 'modai.api.openrouter.key',
      'filename' => 'MODX/Revolution/modSystemSetting/e1cdcfa4993c4947fe170461a24c4c00.vehicle',
    ),
    11 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'c15cb793be88a71f1854162c19a3b04b',
      'native_key' => 'modai.api.custom.key',
      'filename' => 'MODX/Revolution/modSystemSetting/9b515f5273767792e93caf13454b6d6c.vehicle',
    ),
    12 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '9e24c35ca4aa06169a3fcdeb6518d7ec',
      'native_key' => 'modai.api.custom.url',
      'filename' => 'MODX/Revolution/modSystemSetting/450cf1b801b3b3cf9414e556d8d35ad1.vehicle',
    ),
    13 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'df0eb6c668a3a1efdf5b24987e296070',
      'native_key' => 'modai.api.custom.compatibility',
      'filename' => 'MODX/Revolution/modSystemSetting/786c42cd2f8b80bc2a70690380f2d8fa.vehicle',
    ),
    14 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'b51601bb3d0dce6e25398b11d02d5561',
      'native_key' => 'modai.global.text.base_output',
      'filename' => 'MODX/Revolution/modSystemSetting/98082ac166d5c58b1854722008f25e57.vehicle',
    ),
    15 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'acb3c0f4265bcf2e348a6f0a6feea1b1',
      'native_key' => 'modai.global.text.base_prompt',
      'filename' => 'MODX/Revolution/modSystemSetting/114a8272f81623b4fdc6a941326bf779.vehicle',
    ),
    16 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'b4080a292787c9aacf3e104407e2d48b',
      'native_key' => 'modai.global.text.context_prompt',
      'filename' => 'MODX/Revolution/modSystemSetting/e1d384d0d65c13bb411f2d69ae480df2.vehicle',
    ),
    17 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '26d39e92729ce000b90140ef32389bd9',
      'native_key' => 'modai.global.text.max_tokens',
      'filename' => 'MODX/Revolution/modSystemSetting/7b5187997448fd7a3eb77eccc35928b9.vehicle',
    ),
    18 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '032673f63596297dcfd056cb08b0aa4f',
      'native_key' => 'modai.global.text.model',
      'filename' => 'MODX/Revolution/modSystemSetting/80aec18e6ef0199b38ab55b99de77db5.vehicle',
    ),
    19 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'abf25b598dec4cf647eb8ac97ad04aa8',
      'native_key' => 'modai.global.text.temperature',
      'filename' => 'MODX/Revolution/modSystemSetting/95d1ba277d009dc610301811faa1d296.vehicle',
    ),
    20 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'bbbfa5a9190450c1b9ecd39828828e9d',
      'native_key' => 'modai.global.text.custom_options',
      'filename' => 'MODX/Revolution/modSystemSetting/5e109fbab41e27ba8c5c8c73b2ed0a18.vehicle',
    ),
    21 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '724a4e6625130d1f07325c6956fb7531',
      'native_key' => 'modai.global.text.stream',
      'filename' => 'MODX/Revolution/modSystemSetting/8999dacf072b039c4eb557cd03c8a8de.vehicle',
    ),
    22 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'b262e7869f4dd3f4369bf215fdfac102',
      'native_key' => 'modai.global.vision.model',
      'filename' => 'MODX/Revolution/modSystemSetting/85e847bd8e2eadeee69d93b6716384b3.vehicle',
    ),
    23 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '32a75866ddb1cbc55e697b21859626ae',
      'native_key' => 'modai.global.vision.prompt',
      'filename' => 'MODX/Revolution/modSystemSetting/4ab7c92640c9687f7fc134eef76c1cc0.vehicle',
    ),
    24 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '0872eaa43605908089cf7bc83e18225e',
      'native_key' => 'modai.global.vision.custom_options',
      'filename' => 'MODX/Revolution/modSystemSetting/68dede1d0973bf7c875fa4b01648e06c.vehicle',
    ),
    25 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '8e04553c2da3925028e01506a1dc1465',
      'native_key' => 'modai.global.vision.stream',
      'filename' => 'MODX/Revolution/modSystemSetting/3310e3d02d253a6bd5b62e99a4d56869.vehicle',
    ),
    26 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '9411cab62b710e92c146813c2726dae6',
      'native_key' => 'modai.global.vision.max_tokens',
      'filename' => 'MODX/Revolution/modSystemSetting/731383d23157b09c493936d43bcd4fed.vehicle',
    ),
    27 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'c64c7930d5e607ae6590d4738f72966a',
      'native_key' => 'modai.global.image.model',
      'filename' => 'MODX/Revolution/modSystemSetting/b97c60ee00d7714f8c1f75ebb409be95.vehicle',
    ),
    28 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '7829d52e7bb15c6aa089dc49aabefb41',
      'native_key' => 'modai.global.image.style',
      'filename' => 'MODX/Revolution/modSystemSetting/f84674d0d01a1f5ba6ac6e15a2f48e8f.vehicle',
    ),
    29 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '55586011de6b102feedf6d6b709d9265',
      'native_key' => 'modai.global.image.response_format',
      'filename' => 'MODX/Revolution/modSystemSetting/dee5f980661804596ad8ef756b9ee739.vehicle',
    ),
    30 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'f818173e41107e5e71232b1cb2780fa1',
      'native_key' => 'modai.global.image.size',
      'filename' => 'MODX/Revolution/modSystemSetting/fb427cc69c2682f8e1107f15e845d909.vehicle',
    ),
    31 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '43187b22243406a956d5b8e366292d3f',
      'native_key' => 'modai.global.image.quality',
      'filename' => 'MODX/Revolution/modSystemSetting/1124f079fe30c25025021441ecd68406.vehicle',
    ),
    32 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '7fc3589daa273abc9151f76271752498',
      'native_key' => 'modai.global.image.path',
      'filename' => 'MODX/Revolution/modSystemSetting/ac688122b50acea24c81849bf95f0a28.vehicle',
    ),
    33 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '1cfb79f4c67b00f18c890b8fb459f6e7',
      'native_key' => 'modai.global.image.media_source',
      'filename' => 'MODX/Revolution/modSystemSetting/0273899083a53526728b5b8837c0e971.vehicle',
    ),
    34 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '6424b61bc716961db0190ef3782fd7fc',
      'native_key' => 'modai.global.image.download_domains',
      'filename' => 'MODX/Revolution/modSystemSetting/81c1b957d377f6adca80ca690c5bbb0b.vehicle',
    ),
    35 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '49e3b6bb382b5757a5edd7768f90a383',
      'native_key' => 'modai.global.image.custom_options',
      'filename' => 'MODX/Revolution/modSystemSetting/aa709ded0f5be8f97180890be8ac0c34.vehicle',
    ),
    36 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'b114b9012a9e9f656a0dba61f3388b30',
      'native_key' => 'modai.res.fields',
      'filename' => 'MODX/Revolution/modSystemSetting/ee5c6b45a23360472130729e8de57809.vehicle',
    ),
    37 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '4df17613a503f7270a70de00d166b6be',
      'native_key' => 'modai.res.pagetitle.text.prompt',
      'filename' => 'MODX/Revolution/modSystemSetting/f7c2e2f576846bd0fdccf85808d6c8ae.vehicle',
    ),
    38 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '620be6cecc23185a7831ff1dabedf4ef',
      'native_key' => 'modai.res.longtitle.text.prompt',
      'filename' => 'MODX/Revolution/modSystemSetting/a1d8a1154df58a9883250866467671ca.vehicle',
    ),
    39 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '60545ac98221604717d5d38a56cd28fb',
      'native_key' => 'modai.res.introtext.text.prompt',
      'filename' => 'MODX/Revolution/modSystemSetting/ad83d6ea84caeaed2a1565b12e1603e6.vehicle',
    ),
    40 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'dba5c9e786363a22be0a9e6635ba0a7c',
      'native_key' => 'modai.res.description.text.prompt',
      'filename' => 'MODX/Revolution/modSystemSetting/e314a8066e4e5cf9a8d4faec6d0fb79b.vehicle',
    ),
    41 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '28a4255c1ade922e4dd90ccc9c27d46b',
      'native_key' => 'modai.tvs',
      'filename' => 'MODX/Revolution/modSystemSetting/5b81d30698bafeaf25f01f12f4763c45.vehicle',
    ),
    42 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '6180cf85ec638083288363664196c55f',
      'native_key' => 'modai.contexts.resources.name',
      'filename' => 'MODX/Revolution/modSystemSetting/dbde96d52390768feeb4a0d3abe5d194.vehicle',
    ),
    43 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '4f844a9b71cb43342e904e795f6d0a69',
      'native_key' => 'modai.contexts.snippets.name',
      'filename' => 'MODX/Revolution/modSystemSetting/8d012f5c180bdf37f65ba003c167af3c.vehicle',
    ),
    44 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '4433dcebb223f29d0ba32904dc31a258',
      'native_key' => 'modai.contexts.chunks.name',
      'filename' => 'MODX/Revolution/modSystemSetting/6e5c23a89aa4a52054f96e516ab94533.vehicle',
    ),
    45 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'b6cc41dd64ca5da0dfdc45ea5a567aff',
      'native_key' => 'modai.contexts.templates.name',
      'filename' => 'MODX/Revolution/modSystemSetting/1ba734c9b49df5963122b4d855d7ce9a.vehicle',
    ),
    46 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'de898ae05fee827c327bf45952d9fe41',
      'native_key' => 'modai.chat.additional_controls',
      'filename' => 'MODX/Revolution/modSystemSetting/3af960fee1e7627dbae5f3fab51ec0ca.vehicle',
    ),
    47 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '34e3c508245e6d58844e5d35558627bb',
      'native_key' => '34e3c508245e6d58844e5d35558627bb',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/629686b61e3e7f784895d85d12195731.vehicle',
    ),
    48 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modMenu',
      'guid' => '9e2eb5c7087d9d8a55d75000c0f9c3bd',
      'native_key' => 'modai.admin.menu.home',
      'filename' => 'MODX/Revolution/modMenu/0ee4f50cecde4e3ac1bbf2908c42a6de.vehicle',
    ),
    49 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '0f9d2712d7a37ab28c11928c36361187',
      'native_key' => '0f9d2712d7a37ab28c11928c36361187',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/680087e5625762947f15f57c1a56c76c.vehicle',
    ),
    50 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => 'a47c51177a17d0e89f0fb402b67b3ee8',
      'native_key' => 'a47c51177a17d0e89f0fb402b67b3ee8',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/ffae1eaec2448bd0fdf225097a91e161.vehicle',
    ),
    51 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modCategory',
      'guid' => '5b43601159594913384cfc19638df28a',
      'native_key' => NULL,
      'filename' => 'MODX/Revolution/modCategory/5becbbf5a417133ceb42f9f21d9847c0.vehicle',
    ),
    52 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '1f1dbcb65b9a13d041978595f97805dd',
      'native_key' => '1f1dbcb65b9a13d041978595f97805dd',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/0929b721be5338fa62f30574eb18441d.vehicle',
    ),
    53 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '440f9515bebeb1f60d956cfb2f0422f1',
      'native_key' => '440f9515bebeb1f60d956cfb2f0422f1',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/ce52faf96d7aeb2be6fe2804b0a7178f.vehicle',
    ),
    54 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'class' => 'xPDO\\Transport\\xPDOScriptVehicle',
      'guid' => '96a4f6f7e08afdff3d2e6c8c0dde11f5',
      'native_key' => '96a4f6f7e08afdff3d2e6c8c0dde11f5',
      'filename' => 'xPDO/Transport/xPDOScriptVehicle/04a748981e89747d0b58b9bbbef7e4ee.vehicle',
    ),
  ),
);