Модификатор date_format
====================

Форматирует дату согласно указанному формату [strftime()](http://docs.php.net/ru/strftime).
Даты могут быть переданы в виде временных меток unix, временных меток mysql или в виде любой строки, содержащей день,
месяц и год, которую может обработать функция [strftime()](http://docs.php.net/ru/strftime).

```smarty
{$date|date_format:$format = `%b %e, %Y`}
```

Формат по умолчанию: `%b %e, %Y`.

```smarty
{var $ts = time()}

{$ts|date_format:"%Y/%m/%d %H:%M:%S"} выведет 2013/02/08 21:01:43
{$ts|date_format:"-1 day"} выведет вчерашний день, например 2013/02/07 21:01:43

{var $date = "2008-12-08"}

{$ts|date_format:"%Y/%m/%d %H:%M:%S"} выведет 2008/12/08 00:00:00
```

[Конверсионные указатели](http://docs.php.net/ru/strftime#refsect1-function.strftime-parameters) в модификаторе **date_format**:

* %a - сокращенное название дня недели, в зависимости от текущей локали
* %A - полное название дня недели, в зависимости от текущей локали
* %b - сокращенное название месяца, в зависимости от текущей локали
* %B - полное название месяца, в зависимости от текущей локали
* %c - формат даты и времени по умолчанию для текущей локали
* %C - номер века (год, деленный на 100, представленный в виде целого в промежутке от 00 до 99)
* %d - день месяца в десятичном формате (от 01 до 31)
* %D - синоним %m/%d/%y
* %e - день месяца в десятичном формате без ведущего нуля (от 1 до 31)
* %g - Week-based year within century [00,99]
* %G - Week-based year, including the century [0000,9999]
* %h - синоним %b
* %H - часы по 24-часовым часам (от 00 до 23)
* %I - часы по 12-часовым часам (от 01 до 12)
* %j - день года (от 001 до 366)
* %k - часы по 24-часовым часам без ведущего нуля (от 0 до 23)
* %l - часы по 12-часовым часам без ведущего нуля (от 1 до 12)
* %m - номер месяца (от 01 до 12)
* %M - минуты
* %n - символ новой строки
* %p - `am' или `pm', в зависимости от заданного формата времени и текущей локали.
* %r - time in a.m. and p.m. notation
* %R - time in 24 hour notation
* %S - секунды
* %t - символ табуляции
* %T - время в формате %H:%M:%S
* %u - номер дня недели [1,7], где 1-ый день - понедельник
* %U - номер недели в году, считая первое воскресенья года первым днем первой недели
* %V - номер недели в году (по ISO 8601:1988) в диапазоне от 01 до 53, где первая неделя та, у которой хотя бы 4 дня находятся в данном году. Понедельник считается первым днем недели.
* %w - номер дня недели, где 0 - воскресенье
* %W - номер недели в году, считаю первый понедельник первым днем первой недели.
* %x - предпочтительное представление даты для текущих настроек locale без времени
* %X - предпочтительное представление времени для текущих настроек locale без даты
* %y - год в виде десятичного числа без века (от 00 до 99)
* %Y - год в виде десятичного числа включая век
* %Z - часовой пояс или имя или сокращение
* %% - буквальный символ `%'
