Тег {for}
=========

```smarty
{for $counter=<start> to=<end> [step=<step>] [index=$index] [first=$first] [last=$last]}
   {* ...code... *}
   {break}
   {* ...code... *}
   {continue}
   {* ...code... *}
{forelse}
   {* ...code... *}
{/for}
```

### {for}

Переменная `$counter` принимает значение <start> и увеличивает своё значение на <step> на каждой итерации цикла пока не достигнет или не станет больше <end>.
<step> является необязательным аргументом. Если не указан, считается равным единице.
`$index` имеет значение номера текущей итерации. Первая итерация имеет номер 0.
`$first` равно **TRUE**, если итерация первая.
`$last` равно **TRUE**, если итерация последняя.

Поля `<start>`, `<end>`, `<step>` могут быть числами, или переменными, значение которых приводится к числовому.
Значением параметров _index_, _first_, _last_ может быть только переменная (допускаются вложенности на подобии `$a.b.c`, но массив `$a.b` должен быть объявлен).


### {break}

Тег `{break}` используется для выхода из цикла до достижения последней итерации. Если в цикле встречается тег {break}, цикл завершает свою работу, и далее выполняется код, следующий сразу за блоком цикла


### {continue}

Тег `{continue}` используется для прерывания текущей итерации. Если в цикле встречается тег {continue}, часть цикла, следующая после тега, не выполняется, и начинается следующая итерация. Если текущая итерация была последней, цикл завершается.


### {forelse}

Тег `{forelse}` ограничивает код, который должен быть выполнен, если сочетание полей <start>, <end> и <step> не обеспечивают ни одной итерации.
