Тег {include}
=============

Тэги `{include}` используются для включения других шаблонов в текущий. Любые переменные, доступные в текущем шаблоне, доступны и во включаемом.

```smarty
{include "about.tpl"}
```

Вы также можете передать переменные в подключаемый шаблон в виде атрибутов.
Любая переменная, переданная в подключаемый шаблон, доступны только в области видимости подключаемого файла.
Переданные переменные имеют преимущество перед существующими переменными с аналогичными именами.

```smarty
{include "pagination.tpl" count=$total_pages current=$.get.page}
```

Все значения присвоенных переменных восстанавливаются после того, как подключаемый шаблон отработал.
Это значит, что вы можете использовать все переменные из подключающего шаблона в подключаемом, но изменения переменных внутри подключаемого шаблона не будут видны внутри подключающего шаблона после команды {include}.

Если требуется сохранить результат отрисовки шаблона в переменную то используйте `$.fetch($templates, $values)`: 

```smarty
{set $data = $.fetch('user.tpl', ["name" => $data.name, "email" => $data.email])}
```

### {insert}

В отличии от `{include}` тег `{insert}` не вызывает дочерний шаблон во время отрисовки, а вставляет код дочернего шаблона в родительский на момент компиляции.
Это позволяет сэкономить ресурсы на проверке и чтении шаблона. Однако такой формат подключения шаблона имеет ограничения.
Имя шаблона должно быть задано явно, без использования переменных и выражений:

```smarty
{insert 'pagination.tpl'} {* отработает *}
{insert $pagination} {* вызовет ошибку *}
```

Рассмотрим тега `{insert}` на примере. Допустим шаблон `main.tpl` имеет следующий код:

```smarty
a: {$a}
{insert 'b.tpl'}
c: {$c}
```

`b.tpl`:

```
b: {$b}
```

Компилятор увидит шаблон `main.tpl` таким:

```smarty
a: {$a}
b: {$b}
c: {$c}
```
