Тег {macro}
===========

Макросы - фрагмент шаблона который можно повторить сколь угодно раз и в каком угодно месте.
Макросы не имеют общего пространства имен с шаблоном и могут оперировать только переданными переменными.

### {macro}

Обявление макроса происходит при помощи блочного тега `{macro}`

```smarty
{macro plus($x, $y, $z=0)}
    x + y + z = {$x + $y + $z}
{/macro}
```

Вызов макроса происходит при помощи строкового тега `{macro}`. Аргументы передаются стандартно, как атрибуты в HTML тегах

```smarty
{macro.plus x=$num y=100}
```

Во время рекурсивного вызова используйте суффикс macro что бы обратиться к текущему макросу:

```smarty
{macro plus($x, $y, $z=0)}
    ...
    {macro.plus x=2 y=$y}
    ...
{/macro}
```

### {import}

Для использования маросов в другом шаблоне необходимо их импортировать при помощи тега `{import}`

```smarty
{import 'math.tpl'}
```

При импорте можно указать другое пространство имен что бы можно было использовать одноименные макросы из разных шаблонов

```smarty
{import 'math.tpl' as math}
...
{math.plus x=5 y=100}
```

Пространство имен макросов может совпадать с названием какого-либо тега, в данном случае ничего плохого не произойдет: будет вызван макрос, а тег не исчезнит
При необходимости можно импортировать только необходимые макросы, явно указав в теге `{import}`

```smarty
{import [plus, minus, exp] from 'math.tpl' as math}
```
