Тег {set}
=========

### {set}

Тег {set} используется для установки значения переменной в процессе выполнения шаблона.

```smarty
{set $var=(expr)}
```

```smarty
{set $var}
  ... any content ...
{/set}
```

```smarty
{set $var|modifiers}
  ... any content ...
{/set}
```

Имя переменной `$var` должно соответствовать [принятому правилу именования переменных](../syntax.md#Переменные).
Выражение `expr` может быть любое сочетание [переменных](../syntax.md#Переменные), [скалярных значений](../syntax.md#Скалярные+значения) и массивов.

```smarty
{set $v = 5}
{set $v = "value"}
{set $v = $x+$y}
{set $v = 4}
{set $v = $z++ + 1}
{set $v = --$z}
{set $v = $y/$x}
{set $v = $y-$x}
{set $v = $y*$x-2}
{set $v = ($y^$x)+7}

{set $v = [1,2,3]}
{set $v = []}
{set $v = ["one"|upper => 1, 4 => $x, "three" => 3]}
{set $v = ["key1" => $y*$x-2, "key2" => ["z" => $z]]}

{set $v = count([1,2,3])+7}
```

В качестве значения переменной можно задать результат отрисовки фрагмента шаблона:

```smarty
{set $v}
    Some long {$text|trim}
{/set}
```

Такой вариант создания позволяет применить модификаторы к данным перед тем как они будут сохранены в переменную:

```smarty
{set $v|escape} {* применение можификатора к значению *}
    Some long {$text|trim}
{/set}
```

### {add}

Тег {add} делает тоже самое что и тег {set} за исключением того что сначала проверяет наличие переменной и если переменной нет — задет новое значение.

```smarty
{add $var = 'value'}
```
Работу тега можно описать следующим образом:
```smarty
{if $var is not set}
    {set $var = 'value'}
{/if}
```

### {var}

Тег {var} старое название тега {set}, сейчас это одно и тоже.

