Тег {switch}
============

Тег `{switch}` подобен серии операторов `{if}` с одинаковым условием.
Во многих случаях вам может понадобиться сравнивать одну и ту же переменную (или выражение) с множеством различных значений,
и выполнять различные участки кода в зависимости от того, какое значение принимает эта переменная (или выражение).
Это именно тот случай, для которого удобен тег `{switch}`.

Тег `{switch}` в качестве аргумента принимает любое выражение.
Каждый возможный случай описывается тегом `{case value}` значения `value` которых могут быть только явно заданные скалярные значения.
Случаи могут повторятся, в этом случае блоки для которых повторялся случай будут последовательно выполнены по направлению сверху вниз.
Случай `default` подразумевает обработку если ни один случай не произошел.

```smarty
{switch <condition>}
{case value1}
    ...
{case value2, value3, ...}
    ...
{case value3}
    ...
{case default, <value1>}
    ...
{/switch}
```

Рассмотрим пример:

```smarty
{switch $color}
{case 'red', 'scarlet'}
    Оттенок красного цвета
{case 'green', 'harlequin'}
    Оттенок зеленого цвета
{case 'black', 'grey', 'gray'}
    Черный цвет
{case 'white', 'grey', 'gray'}
    Белый цвет
{case default, 'unknown'}
    Неизвестный цвет
{/switch}
```

если задать `$color = 'red'` результатом будет:

```
Оттенок красного цвета
```

для случая `$color = 'grey'` будут вызваны два бока:

```
Черный цвет
Белый цвет
```

случаи `$color = 'yellow'` и `$color = 'unknown'` будут обработаны последним блоком:

```
Неизвестный цвет
```