<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'license' => 'GNU GENERAL PUBLIC LICENSE
   Version 2, June 1991
--------------------------

Copyright (C) 1989, 1991 Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.

Preamble
--------

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation\'s software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author\'s protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors\' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone\'s free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.


GNU GENERAL PUBLIC LICENSE
TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
---------------------------------------------------------------

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program\'s
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients\' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

NO WARRANTY
-----------

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

---------------------------
END OF TERMS AND CONDITIONS',
    'readme' => '# VersionX 3 #

_If you\'re looking for the current stable version of VersionX, see the [v2 branch](https://github.com/modmore/VersionX/tree/master)._

VersionX is a versioning system for the MODX content management system. It keeps track of changes to your resources, templates, template variables, chunks, snippets, plugins, and _now in v3 custom objects too!_ You can view historic changes and revert changes from a simple dashboard.

![VersionX Screenshot](https://user-images.githubusercontent.com/5160368/236378160-f0e88939-71e4-4d38-b750-f49ae84b068d.png)

v3.0 is a complete rewrite and is not compatible with v2.
There is, however, a migration utility included that will assist with moving your old data to the new tables.

## Funding Goal Reached ##

VersionX 3.0 was made possible by community funding. Read through [the conversation](https://github.com/modmore/VersionX/issues/4) to learn more!

## Requirements ##

- MODX 2.6.5+
- PHP 7.4+

## Installation ##

VersionX can be installed from either the [modmore package provider](https://modmore.com/about/package-provider/), or the [MODX package provider](https://extras.modx.com/package/versionx?version=2.4.0-pl).

## New UI ##
The UI in VersionX 3.0 has been overhauled and simplified.

**Manager Page**

The VersionX manager page is availble at `Extras -> VersionX` in the MODX manager.
Here you\'ll find the main objects grid that lists all objects that have at least one version stored.
They are sorted by the latest update, and can be filtered by the package they belong to, the type of
object (Resource, Template, Chunk, Snippet, TV, Plugin, or custom), the user who made the update and the date.

By default, only core object types are displayed. If you would like to include custom objects, please refer
to the sections **Object Types** and **Versioning Custom Objects** below.

To view the stored versions for an object, right-click on it and select `View Details`. A window will open
with a list of deltas for that object. Each delta represents a grouping of all the fields that changed at a
particular point in time. Inside each delta you\'ll see a list of rendereded
[diffs](https://en.wikipedia.org/wiki/Diff) for each field name showing the before and after values.]

**Versions Tab**

On each Resource and Element manager page, you\'ll see an extra "Versions" tab that\'s been added by VersionX.
Switching to this tab will display the same list of deltas as when opening the detail window on the
VersionX manager page.

## Reverting Changes ##

Reverting changes is performed either on the versions tab of the manager Resource/Element form, or via the
main VersionX manager page.

Look through the list of deltas, and find the one you want to revert to. There are three buttons available
for reverting.

- `Undo`: On the right-hand side of every diff, you\'ll see **_undo_** buttons for each field listed. Clicking undo will revert the change for that field only, ignoring all the other fields within that delta.
- `Revert these changes`: In the top-right corner of each delta, you\'ll see the **_Revert these changes_** button. This will revert all fields within that delta, but no others.
- `Revert all fields to this point in time`: This button sits between deltas, and reverts ALL fields regardless of which delta they are in, to that point in time. (_This point in time_ refers to the "end time" of the delta just below it).

## Fields ##

Different field types in v3 allow for unique behavior when creating, reverting, or rendering deltas. In addition to the standard [Text field](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/src/Fields/Text.php), the [Properties field](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/src/Fields/Properties.php) is now available.

Properties fields are defined for an object in the type class (see Object Types section below) and are typically used for fields that contain more than one value,
such as a serialized value. The properties field breaks the value apart recursively and versions each item as its own field when stored in a delta.
This provides more granular control over what can be reverted, compared to a normal Text field where all values must be reverted at once.
An example of the Properties field being defined for a Resource can be found [here](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/src/Types/Resource.php#L32-L34).

An Image field is also planned that would allow rendering of the before and after images within the diff.

## Object Types ##

Objects may be expected to behave differently from one another. We expect when saving a resource, it should also remember the TV values on that resource, whereas when saving a chunk, we don\'t need to worry about that.

To handle these different behaviours, VersionX uses configuration classes that extend the `\\modmore\\VersionX\\Types\\Type` class.

Here\'s the object _Type_ class for versioning chunks (modChunk):

```php
<?php

namespace modmore\\VersionX\\Types;

class Chunk extends Type
{
    // The class to be versioned
    protected string $class = \\modChunk::class;

    // The id of the HTML element where the "Versions" tab will be added.
    protected string $tabId = \'modx-chunk-tabs\';

    // The id of the ExtJS panel where versions will be rendered
    protected string $panelId = \'modx-panel-chunk\';

    // Package name. If you\'re versioning a custom object, change this from core.
    protected string $package = \'core\';

    // The primary field name for this object (for a resource it might be pagetitle)
    protected string $nameField = \'name\';

    // List the field names to appear at the top when displaying diffs.
    protected array $fieldOrder = [
        \'name\',
        \'description\',
        \'content\',
    ];

    // List field names that should not be versioned
    protected array $excludedFields = [
        \'id\',
        \'snippet\',
    ];
}
```

VersionX will check these values when performing actions.

## Versioning Custom Objects ##

In addition to resources and elements, VersionX can work with custom objects. The only requirement is that it must be a derivative of xPDOObject.

Example custom Type class for a Commerce product:

```php
<?php

namespace MyModuleNamespace;

use modmore\\VersionX\\Fields\\Image;
use modmore\\VersionX\\Fields\\Properties;
use modmore\\VersionX\\Types\\Type;

class MyProduct extends Type {
    protected string $class = \\comProduct::class;
    protected string $package = \'commerce\';
    protected string $nameField = \'name\';
    protected array $excludedFields = [
        \'id\',
    ];
    protected array $fieldOrder = [
        \'name\',
        \'description\',
        \'pricing\',
        \'sku\',
    ];
    protected array $fieldClassMap = [
        \'properties\' => Properties::class,
        \'image\' => Image::class,
    ];

    /**
     * Here we are loading the Commerce package via it\'s service class. This is required in order to have
     * custom objects show up in the main VersionX objects grid.
     */
    public static function loadCustomPackage(\\modX $modx): bool
    {
        // While we\'re using $modx->getService() here, depending on your package/objects you might use
        // $modx->loadClass(), or $modx->addPackage() instead.
        if (!$modx->getService(\'commerce\', \'Commerce\', MODX_CORE_PATH . \'components/commerce/model/commerce/\')) {
            // Return false if it failed
            return false;
        }

        return true;
    }
}
```

**Create versions of a custom object**

Here\'s an example of how to create a delta of an object using the MyProduct type class above:

```php
$path = $modx->getOption(\'versionx.core_path\', null, MODX_CORE_PATH . \'components/versionx/\');
require $path . \'vendor/autoload.php\';

$versionX = new \\modmore\\VersionX\\VersionX($modx);

$type = new \\MyModuleNamespace\\MyProduct($versionX);
$result = $versionX->deltas()->createDelta($id, $type);
```

Here we are getting the VersionX autoloader (so PHP knows where the VersionX classes are), then instantiating VersionX, instantiating our own custom type class, then calling `createDelta()` and passing our custom type class `$type` and the `$id` of the object we want to version.

You can see an [example of this in the VersionX plugin](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/elements/plugins/versionx.plugin.php#L41-L42), where we are creating a new delta of a resource when saved. The Object Type in this case is `\\modmore\\VersionX\\Types\\Resource`.

```php
$type = new \\modmore\\VersionX\\Types\\Resource($versionX);
$result = $versionX->deltas()->createDelta($id, $type);
```

Now what happens if you want to include extra data in the delta that\'s not a field of your object?
Saving TV values along with resources are an excellent example of this. In your extended custom type class, you
can use the [includeFieldsOnCreate()](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/src/Types/Type.php#L162-L173) method to add extra data to the version. An [example of this](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/src/Types/Resource.php#L42-L105) can be
found in the `Resource` type class.

When reverting to a previous version of an object, you\'re going to want to revert the values of those
extra fields to the values from the previous version. To do this use the [afterRevert()](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/src/Types/Type.php#L186-L202) method in your
extended Type class. See the example reverting TV values in the [Resource](https://github.com/modmore/VersionX/blob/3.x/core/components/versionx/src/Types/Resource.php#L108-L152) class.


**Display the custom object versions in the VersionX grid**

The most important part for custom objects is the `loadCustomPackage()` method, as seen in the example above.
This will allow the main VersionX objects grid to display your custom object versions in addition to the regular core objects.
This method should be used to load the xPDO objects. Different packages may need to be loaded in different ways; for example
in the example above the Commerce package is loaded by using the `$modx->getService()` method. For other packages, it might
be more appropriate to use `$modx->loadClass()`, `$modx->addPackage()`, or the MODX 3+ `bootstrap.php` file.

Your custom type class could be located anywhere, so we need to let VersionX know where to find it. For this
the `versionx.custom_type_classes` system setting exists. The class name and the file location of each custom package should be added in JSON format to the system setting.
e.g.

```json
[{
  "class": "\\\\MyModuleNamespace\\\\MyProduct",
  "path": "{core_path}components/commerce_mymodule/src/MyModuleNamespace/MyProduct.php"
},{
  "class": "\\\\AnotherNamespace\\\\AnotherClass",
  "path": "{core_path}components/packagename/src/AnotherNamespace/AnotherClass.php"
}]
```

VersionX will check this system setting when loading the main objects grid, and then run the `loadCustomPackage()` method
for each class listed there.

You can then see your custom object versions in the VersionX grid. Note the object with the name `MyProduct` and the
class `comProduct` listed in the screenshot below:

![Custom Object in Grid](https://github.com/modmore/VersionX/assets/5160368/bf323859-a971-47cf-8a90-5904426179ee)


## Merging Deltas ##

Previously, VersionX stored the entire object each save. This, as you can imagine, caused the database tables to grow rather quickly.
As of v3, each version only contains the fields that have changed within a delta.

Merging deltas are a key function of VersionX, designed to keep storage space to a minimum. Merging deltas is intended
to be handled by a nightly cronjob, though it can also be triggered manually by the **_Optimise Storage_** button at
the top of the VersionX manager page.

The script to run for the cron is located at `core/components/versionx/cron.php`

So to run it every midnight, in your crontab you might put:
```
0 0 * * * php /var/www/public/core/components/versionx/cron.php > /dev/null 2>&1
```

VersionX will look at how old deltas are and merge then depending on the timeframe.

- `1 week ago` - Deltas older than a week will be merged to a single delta for a given hour.
  _This leaves at most 168 unique deltas per object per week, or 8736 per year._
- `1 month ago` - Deltas older than a month will be merged to a single delta for a given day.
  _This leaves at most 7 unique deltas per object per week, or 364 per year_
- `3 months ago` - Deltas older than 3 months will be merged to a single delta for a given week.
  _This leaves at most 1 unique delta per object per week, or 52 per year._
- `18 months ago` - Deltas older than 18 months will be merged to a single delta for a given month.
  _This leaves at most 1 unique delta per object per month, or 12 per year._
- `5 years ago` - Deltas older than 5 years will be merged to a single delta for a given year.

The initial delta on each object, plus any delta marked as a **_milestone_** will not be merged.

## Milestones ##

Within the delta grid UI, you can set a milestone tag (e.g. "Client Review" or "Went Live!") on a delta by
clicking the flag icon.
A milestone represents an important version that should be preserved as is, and as such is never merged.
Click the milestone tag again to remove it if you no longer wish to keep it separate.

## Migrating from 2.x ##

A separate script has been included to migrate version data from the VersionX 2.x database tabled.

After upgrading to version 3, run the following from the command line:
```
php /your/path/core/components/versionx/migrate.php
```

## Contributions ##
VersionX is open source, and free to use. If you would like to support further development, feel free to contribute with either code (in the form of a PR on this repo) or monetary contributions. Hit the link to donate: https://modmore.com/extras/versionx/donate/
',
    'changelog' => 'VersionX 3.2.1-pl
-----------------
Released on 2025-04-11

- Update migration script to use json_encode instead of serialize to match changes to vxDeltaField in the last release. [#145]

VersionX 3.2.0-pl
-----------------
Released on 2025-03-14

- Add MagicPreview (v1.5.1+) integration to enable previews of resource deltas before reverting. [#142]
- Optimize editor filter query for large data sets. (@matdave) [#143]

VersionX 3.1.3-pl
-----------------
Released on 2025-02-01

- Add before_type and after_type fields to vxDeltaField to more accurately preserve types when reverting. [#138]
- Fix blank array being created as first element when splitting properties fields. [#138]
- Fix null type error on some resources when running the migration script (@matdave) [#140]
- Fix undefined this.proxy browser console error when loading dashboard widget. [b0dbb40]
- Bump dependency nesbot/carbon from 2.66.0 to 2.72.6 [#141]

VersionX 3.1.2-pl
-----------------
Released on 2024-08-16

- Prevent initial delta being created by package resolver if already created by a previous install [#136]

VersionX 3.1.1-pl
-----------------
Released on 2024-06-28

- Fix dashboard widget default sizing in MODX 2.x [#133]
- Ensure option exists to edit selected resource in dashboard widget [#132]
- Fix warning in migration script [#134]

VersionX 3.1.0-pl
-----------------
Released on 2024-05-10

- Add dashboard widget that displays recent resource updates
- Small visual tweaks to the objects grid

VersionX 3.0.1-pl
-----------------
Released on 2024-03-07

- Update version 3 changes to properly use lexicons
- Make the action column on VersionX grids narrower on MODX 3
- Fix possible fatal error in migration script. (@jako) [#127]
- Update some German lexicon entries. (@jako) [#125]
- Fix fatal error due to a MODX 2 type hint when running the migration script on MODX 3

VersionX 3.0.0-pl
-----------------
Released on 2023-09-06

- Official 1.0 release on modmore.com

VersionX 3.0.0-beta2
-----------------
Released on 2023-06-17

- Force a full snapshot including all fields on the first delta of an object.
- Remove all revert action buttons from initial delta.
- Add system setting versionx.custom_type_classes so VersionX knows where to find any custom type classes.
- Add a loadCustomPackage() method to modmore\\VersionX\\Types\\Type to allow loading custom packages in different fashions.
- Remove unstable beta alert from setup options window introduced in beta1.

VersionX 3.0.0-beta1
-----------------
Released on 2023-05-05

- Initial beta version of 3.0
- Complete rewrite

VersionX 2.4.0-pl
-----------------
Released on 2022-08-14

- Remove unused VersionX::getChunk()
- Fix creating snippet and chunk versions on MODX 3 [#121]
- Also trigger on Fred resource saves [#112]

VersionX 2.3.2-pl
-----------------
Released on 2020-06-25

- Fix several XSS vulnerabilities in the VersionX tabs (resources and templates, where the attack is in the rendered name) and the compare versions view in any non-content field.
- Fix incorrect assets path on the namespace [#116]

VersionX 2.3.1-pl
-----------------
Released on 2020-04-06

- Lower minimum required PHP version to 7.1

VersionX 2.3.0-pl
-----------------
Released on 2020-02-07

- Compatible with MODX 3 (alpha2+) - will likely receive another upgrade in the future improving styling to match 3.x.
- Prevent installation when server requirements are not met
- Fix detail grids showing narrow columns in MODX 3

VersionX 2.2.2-pl
-----------------
Released on 2019-08-22

- VersionX now requires PHP 7.1+ and MODX 2.6+
- Hide users dropdown if user lacks view_user permission [#96]
- Fix forms returning to the first tab on save when the VersionX tab is added [#74]
- Show proper error message when trying to view a non-existent version [#106]
- Fix filtering on the element/resource view [#94]
- Mark the Filter buttons as primary to make them stand out more
- Fix published on date and introtext not showing on the resource detail view [#100]

VersionX 2.2.1-pl
-----------------
Released on 2018-12-17

- Fix the dashboard widget causing an E_FATAL and not using the right links

VersionX 2.2.0-pl
-----------------
Released on 2018-12-14

- #105 Update component to make use of namespace-based routing instead of modAction
- Refactor single index controller into separate controllers for each view
- Refactor flat file processors to class based processors
- Cleanup old processor files during installation
- Use MODx.loadPage instead of window.location for opening links to allow middle click in 2.7
- Cleanup of various legacy (VersionX.action, $versionx->getAction)
- Highlight values that have changed in bold green
- Make the "Compare to" dropdown bigger so you can see the full date/time
- Properties tabs that are not implemented have been removed instead of shown as disabled tab
- #86 Fix template not shown on resource fields
- Show a more visual diff (red/green) of content changes

VersionX 2.1.3-pl
-----------------
Released on 2015-10-25

- #79/82 Fix undefined constant error

VersionX 2.1.2-pl
-----------------
Released on 2015-05-16

- #78 Fix critical issue where you could not save a resource properly

VersionX 2.1.1-pl
-----------------
Released on 2015-05-15

- #65 Make sure Versions tab shows up on snippets
- #67 Some slight improvements to the UI in 2.3
- #73 Fix resource type combo, prevent annoying "unknown column \'name\' in \'order clause\'" error.
- Improve loading of VersionX service in plugin
- Add Danish translation (thanks Jacob & Dennis at Better Collective!)
- #59 Fix E_NOTICE issue in PHP < 5.4

VersionX 2.1.0-pl
-----------------
Released on 2013-01-14

#52 Prevent cutting off content because of non-breaking spaces.
#42 Revert objects from the grid (both tabs and component)
Add ability to revert Template Variables.
Add ability to revert Plugins.
Add ability to revert Snippets.
Add ability to revert Templates.
Add ability to revert Chunks.
#45 Implement tab states for easier back-and-forth in the component.
#43 Improve setup process performance by using getIterator instead of getCollection.
#44 Fix htmlentities() charset error.

VersionX 2.0.0-pl
-----------------
Released on 2012-10-29

#39 Add Swedish translation (thanks fractalwolfe!)
#33, #34 Fix issue with multi byte (UTF-8) sequences returning empty content.
#36 Fix ID clashes in component.

VersionX 2.0.0-rc4
------------------
Released on 2012-07-19

Fix critical issue on Firefox (possibly others too) affecting TVs.

VersionX 2.0.0-rc3
------------------
Released on 2012-07-08

Add Plugins UI to the component and as tab on the plugin update panel.
Add Snippets UI to the component and as tab on the snippets update panel.
#16 Add a cachebust to javascripts based on version number to eliminate browser cache issues.
#32 Fix E_NOTICE error in VersionX.checkLastVersion possibly causing install/save issues.
#27 Fix resolvers preventing proper uninstall
Clean up javascript to satisfy PhpStorm\'s JS validation.
Re-align form buttons and tiny bit of UI cleanup.
#31 Fix action bar and VersionX component in IE
#29 Fix issue with empty grids until applying a filter in 2.2.4.

VersionX 2.0.0-rc2
------------------
Released on 2012-05-28

Add Recent Resource Changes dashboard widget for 2.2+.
Add Chunks UI to the component, and tabs to the update panel.
Change TV grid to follow same column order as others
Change object field behavior from searching on IP to searching on name
Add versions tab to template variable update screens.
#22 Make sure the cache gets cleared when reverting a resource.
#26 Fix critical issue handling static resources.
#24/#9 Added German translation (Thanks @exside!)
Fix "upd" message being logged to the error log.
Added Russian translation (Thanks Ivan Klimchuk!)

VersionX 2.0.0-rc1
------------------
Released on 2012-05-03

If TVs don\'t have a caption, make sure to fall back to its name.
Add status message on reverting a Resource.

VersionX 2.0.0-dev13
--------------------
Released on 2012-04-09

Add ability to toggle versioning of Resources or element types through system settings.
Add ability to revert Resources.
Add Dutch translation (Thanks @Engelbert!)
Add new "Template Variables" tab to component. (Thanks Adam!)
Prevent E_NOTICE errors on main controller.

VersionX 2.0.0-dev12
--------------------
Released on 2012-04-03

Add new "Versions" tab to Templates panel.
Normalize/refactor process of adding tabs to non-component panels through the plugin.
Add Templates tab to VersionX component. (Thanks Adam!)
Fix filtering on Resource panel. (Thanks Adam!)

VersionX 2.0.0-dev11
--------------------
Released on 2012-01-22

Fix/re-introduce support for PHP 5.2

VersionX 2.0.0-dev10
--------------------
Released on 2012-01-21

Fix linking from/to components, including when comparing.

VersionX 2.0.0-dev9
-------------------
Released on 2012-01-21

Add settings to setup for debug and showing/hiding the resource versions tab.
Add tab on resource panel for versions.
#5 Make sure changes were made before creating a new version, normalized and now also for all element types.
#1 Add ability to create a snapshot of all resources and elements during install.
#2 Added TV compatibility for 2.0.8.

VersionX 2.0.0-dev8
-------------------
Released on 2012-01-20
Contributors:
-------------
- Adam Lundrigan
----------------

Make pretty for MODX 2.2 (yes, that means it\'s yucky-ish in 2.1, but it\'s super in 2.2!)
#10 Fix bug in Google Chrome (Thanks Adam!)

VersionX 2.0.0-dev7
-------------------
Released on 2011-11-25

Fix bug where it wouldn\'t create a version when no earlier versions existed.

VersionX 2.0.0-dev6
-------------------
Released on 2011-10-14

#5 Add check for Resource versions to make sure there are changes.
Use colors in the detail/compare resource display to see changes/additions/removals.
Respect manager_date_format and manager_time_format settings in drop down.
Add the mode to dropdown display of versions to compare to, and prevent error notices.

VersionX 2.0.0-dev5
-------------------
Released on 2011-10-14

Fix content_disposition display on version details panel.
Increase width of statictextfield
Prevent silly error messages when loading resource version lists.

VersionX 2.0.0-dev4
-------------------
Released on 2011-10-14

Add compare functionality for resource versions.
Add resource version details panel.
Reorder of Resource filter options for easier duplication at a later stage.

VersionX 2.0.0-dev3
-------------------
Released on 2011-08-27

Fix endless save loop in MODX versions earlier than 2.1 due to lack of support for TVs.

VersionX 2.0.0-dev2
-------------------
Released on 2011-08-27

First proper build.
',
    'setup-options' => 'versionx-3.2.1-pl/setup-options.php',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modNamespace',
      'guid' => '5699897e51f1fc8587d6937de02a290d',
      'native_key' => 'versionx',
      'filename' => 'modNamespace/61ac6b2ac62a5cdf1486d571ee96248c.vehicle',
      'namespace' => 'versionx',
    ),
    1 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOFileVehicle',
      'class' => 'xPDOFileVehicle',
      'guid' => 'ac6982380aa00e85aad77d79f9aecb9d',
      'native_key' => 'ac6982380aa00e85aad77d79f9aecb9d',
      'filename' => 'xPDOFileVehicle/75310d2c6f9c1a5cf2a5d248483f07f8.vehicle',
    ),
    2 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOFileVehicle',
      'class' => 'xPDOFileVehicle',
      'guid' => 'f697ff490621be8441d830fea64a0944',
      'native_key' => 'f697ff490621be8441d830fea64a0944',
      'filename' => 'xPDOFileVehicle/6271dae8dedd45e41462d942450c4d00.vehicle',
    ),
    3 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '61e33e0ef6d912cf8ea9274a6a4635a1',
      'native_key' => 'versionx.custom_type_classes',
      'filename' => 'modSystemSetting/567647a3d5e1355a3daa69082ffa5fea.vehicle',
      'namespace' => 'versionx',
    ),
    4 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'a6b9aa388fe5f6a76174fcb15c264d9b',
      'native_key' => 'versionx.formtabs.resource',
      'filename' => 'modSystemSetting/4e1eddf1c5096ec743659660b6ba02fc.vehicle',
      'namespace' => 'versionx',
    ),
    5 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '6f8324e236d22caf7fa8eaeda1e91ab3',
      'native_key' => 'versionx.formtabs.template',
      'filename' => 'modSystemSetting/dd03d07c86125ea933892fdf797c7511.vehicle',
      'namespace' => 'versionx',
    ),
    6 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '37fadd155dfe5b7f69cfc6f39fd813a7',
      'native_key' => 'versionx.formtabs.templatevariables',
      'filename' => 'modSystemSetting/1b0940c1994484006741fe1d0f740975.vehicle',
      'namespace' => 'versionx',
    ),
    7 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'bb8d7bca27934b167fb937737aa1f252',
      'native_key' => 'versionx.formtabs.chunk',
      'filename' => 'modSystemSetting/95fd003e88e112efd02867335504cc28.vehicle',
      'namespace' => 'versionx',
    ),
    8 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '3d1c8c921a407d9c53d84a9cd4448dc2',
      'native_key' => 'versionx.formtabs.snippet',
      'filename' => 'modSystemSetting/9670214f3078fd645b355fdc6b6c5f23.vehicle',
      'namespace' => 'versionx',
    ),
    9 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '1176243f56c6513799ae9f8ec20e39de',
      'native_key' => 'versionx.formtabs.plugin',
      'filename' => 'modSystemSetting/092a3a294ae88a568cfd9728592c5e60.vehicle',
      'namespace' => 'versionx',
    ),
    10 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'bc3b60c53f722c411161790c8a063b7b',
      'native_key' => 'versionx.enable.resources',
      'filename' => 'modSystemSetting/458268ca3db6c93515f778514e95d9d5.vehicle',
      'namespace' => 'versionx',
    ),
    11 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '824bfb1ecefe15d3c38c5e8feeba46f0',
      'native_key' => 'versionx.enable.templates',
      'filename' => 'modSystemSetting/e17769886c010d2627d5efecd5f8f74a.vehicle',
      'namespace' => 'versionx',
    ),
    12 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '7285d3de5f858260be0797cf2383a216',
      'native_key' => 'versionx.enable.templatevariables',
      'filename' => 'modSystemSetting/ee63c268059e610d81dc4e57289215ac.vehicle',
      'namespace' => 'versionx',
    ),
    13 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '876ef7879539c5f3254bc380b93266e2',
      'native_key' => 'versionx.enable.chunks',
      'filename' => 'modSystemSetting/9d5d86e3e97af4534807619ccabab409.vehicle',
      'namespace' => 'versionx',
    ),
    14 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => 'bae51fc1a1a86b79720b4eafecbf1939',
      'native_key' => 'versionx.enable.snippets',
      'filename' => 'modSystemSetting/6fa957eef8a906b823482c2bb19a1d3a.vehicle',
      'namespace' => 'versionx',
    ),
    15 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modSystemSetting',
      'guid' => '1d1e32a6364f9a454e962f7d64c20f29',
      'native_key' => 'versionx.enable.plugins',
      'filename' => 'modSystemSetting/ad6651789626f5858bbe5a166931b8d2.vehicle',
      'namespace' => 'versionx',
    ),
    16 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modPlugin',
      'guid' => '92bf4b5c9e645875b9fac24e84da48c9',
      'native_key' => 1,
      'filename' => 'modPlugin/b23bc6f7f5275309dbbd55885e21af13.vehicle',
      'namespace' => 'versionx',
    ),
    17 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modMenu',
      'guid' => 'be834429ce9ca680cccf62fce1c4d087',
      'native_key' => 'versionx',
      'filename' => 'modMenu/8178598560d62fd610d0acb01ea2dcc6.vehicle',
      'namespace' => 'versionx',
    ),
    18 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modDashboardWidget',
      'guid' => '4f983f06fad5afb1f5ce62a20d11b632',
      'native_key' => NULL,
      'filename' => 'modDashboardWidget/fba0fe1cad9a30ee01122fdceeefd3d1.vehicle',
      'namespace' => 'versionx',
    ),
    19 => 
    array (
      'vehicle_package' => 'transport',
      'vehicle_class' => 'xPDOObjectVehicle',
      'class' => 'modCategory',
      'guid' => '19b0e36c202ceb2ddb9706430da43dc6',
      'native_key' => 1,
      'filename' => 'modCategory/69439f1cad13f40354837d74665d193f.vehicle',
      'namespace' => 'versionx',
    ),
  ),
);